package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationDatasetLocation(
    s3Uri: Optional[S3Uri] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation = {
    import EvaluationDatasetLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation
      .builder()
      .optionallyWith(
        s3Uri.map(value => S3Uri.unwrap(value): java.lang.String)
      )(_.s3Uri)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly =
    zio.aws.bedrock.model.EvaluationDatasetLocation.wrap(buildAwsValue())
}
object EvaluationDatasetLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationDatasetLocation =
      zio.aws.bedrock.model.EvaluationDatasetLocation(s3Uri.map(value => value))
    def s3Uri: Optional[S3Uri]
    def getS3Uri: ZIO[Any, AwsError, S3Uri] =
      AwsError.unwrapOptionField("s3Uri", s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation
  ) extends zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly {
    override val s3Uri: Optional[S3Uri] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Uri())
      .map(value => zio.aws.bedrock.model.primitives.S3Uri(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDatasetLocation
  ): zio.aws.bedrock.model.EvaluationDatasetLocation.ReadOnly = new Wrapper(
    impl
  )
}
