package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationMetricName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EvaluationDatasetMetricConfig(
    taskType: zio.aws.bedrock.model.EvaluationTaskType,
    dataset: zio.aws.bedrock.model.EvaluationDataset,
    metricNames: Iterable[EvaluationMetricName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig = {
    import EvaluationDatasetMetricConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig
      .builder()
      .taskType(taskType.unwrap)
      .dataset(dataset.buildAwsValue())
      .metricNames(metricNames.map { item =>
        EvaluationMetricName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly =
    zio.aws.bedrock.model.EvaluationDatasetMetricConfig.wrap(buildAwsValue())
}
object EvaluationDatasetMetricConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationDatasetMetricConfig =
      zio.aws.bedrock.model.EvaluationDatasetMetricConfig(
        taskType,
        dataset.asEditable,
        metricNames
      )
    def taskType: zio.aws.bedrock.model.EvaluationTaskType
    def dataset: zio.aws.bedrock.model.EvaluationDataset.ReadOnly
    def metricNames: List[EvaluationMetricName]
    def getTaskType
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationTaskType] =
      ZIO.succeed(taskType)
    def getDataset
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationDataset.ReadOnly] =
      ZIO.succeed(dataset)
    def getMetricNames: ZIO[Any, Nothing, List[EvaluationMetricName]] =
      ZIO.succeed(metricNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig
  ) extends zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly {
    override val taskType: zio.aws.bedrock.model.EvaluationTaskType =
      zio.aws.bedrock.model.EvaluationTaskType.wrap(impl.taskType())
    override val dataset: zio.aws.bedrock.model.EvaluationDataset.ReadOnly =
      zio.aws.bedrock.model.EvaluationDataset.wrap(impl.dataset())
    override val metricNames: List[EvaluationMetricName] = impl
      .metricNames()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.EvaluationMetricName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig
  ): zio.aws.bedrock.model.EvaluationDatasetMetricConfig.ReadOnly = new Wrapper(
    impl
  )
}
