package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationInferenceConfig(
    models: Optional[Iterable[zio.aws.bedrock.model.EvaluationModelConfig]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig = {
    import EvaluationInferenceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig
      .builder()
      .optionallyWith(
        models.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.models)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly =
    zio.aws.bedrock.model.EvaluationInferenceConfig.wrap(buildAwsValue())
}
object EvaluationInferenceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationInferenceConfig =
      zio.aws.bedrock.model.EvaluationInferenceConfig(
        models.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def models
        : Optional[List[zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly]]
    def getModels: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("models", models)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig
  ) extends zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly {
    override val models
        : Optional[List[zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.models())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.EvaluationModelConfig.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationInferenceConfig
  ): zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly = new Wrapper(
    impl
  )
}
