package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationJobStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus
}
object EvaluationJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus
  ): zio.aws.bedrock.model.EvaluationJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.DELETING =>
      val r = Deleting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.FAILED
  }
  case object Stopping extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.STOPPED
  }
  case object Deleting extends zio.aws.bedrock.model.EvaluationJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobStatus.DELETING
  }
}
