package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationJobType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.EvaluationJobType
}
object EvaluationJobType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.EvaluationJobType
  ): zio.aws.bedrock.model.EvaluationJobType = value match {
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobType.HUMAN =>
      val r = Human
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationJobType.AUTOMATED =>
      val r = Automated
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.EvaluationJobType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobType =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobType.UNKNOWN_TO_SDK_VERSION
  }
  case object Human extends zio.aws.bedrock.model.EvaluationJobType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobType =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobType.HUMAN
  }
  case object Automated extends zio.aws.bedrock.model.EvaluationJobType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationJobType =
      software.amazon.awssdk.services.bedrock.model.EvaluationJobType.AUTOMATED
  }
}
