package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EvaluationModelConfig(
    bedrockModel: Optional[zio.aws.bedrock.model.EvaluationBedrockModel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig = {
    import EvaluationModelConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig
      .builder()
      .optionallyWith(bedrockModel.map(value => value.buildAwsValue()))(
        _.bedrockModel
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly =
    zio.aws.bedrock.model.EvaluationModelConfig.wrap(buildAwsValue())
}
object EvaluationModelConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationModelConfig =
      zio.aws.bedrock.model
        .EvaluationModelConfig(bedrockModel.map(value => value.asEditable))
    def bedrockModel
        : Optional[zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly]
    def getBedrockModel: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly
    ] = AwsError.unwrapOptionField("bedrockModel", bedrockModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig
  ) extends zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly {
    override val bedrockModel
        : Optional[zio.aws.bedrock.model.EvaluationBedrockModel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bedrockModel())
        .map(value => zio.aws.bedrock.model.EvaluationBedrockModel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationModelConfig
  ): zio.aws.bedrock.model.EvaluationModelConfig.ReadOnly = new Wrapper(impl)
}
