package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.S3Uri
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EvaluationOutputDataConfig(s3Uri: S3Uri) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig = {
    import EvaluationOutputDataConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig
      .builder()
      .s3Uri(S3Uri.unwrap(s3Uri): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly =
    zio.aws.bedrock.model.EvaluationOutputDataConfig.wrap(buildAwsValue())
}
object EvaluationOutputDataConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationOutputDataConfig =
      zio.aws.bedrock.model.EvaluationOutputDataConfig(s3Uri)
    def s3Uri: S3Uri
    def getS3Uri: ZIO[Any, Nothing, S3Uri] = ZIO.succeed(s3Uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig
  ) extends zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly {
    override val s3Uri: S3Uri =
      zio.aws.bedrock.model.primitives.S3Uri(impl.s3Uri())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationOutputDataConfig
  ): zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly = new Wrapper(
    impl
  )
}
