package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  EvaluationModelIdentifier,
  Timestamp,
  EvaluationJobName,
  EvaluationJobArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class EvaluationSummary(
    jobArn: EvaluationJobArn,
    jobName: EvaluationJobName,
    status: zio.aws.bedrock.model.EvaluationJobStatus,
    creationTime: Timestamp,
    jobType: zio.aws.bedrock.model.EvaluationJobType,
    evaluationTaskTypes: Iterable[zio.aws.bedrock.model.EvaluationTaskType],
    modelIdentifiers: Iterable[EvaluationModelIdentifier]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.EvaluationSummary = {
    import EvaluationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.EvaluationSummary
      .builder()
      .jobArn(EvaluationJobArn.unwrap(jobArn): java.lang.String)
      .jobName(EvaluationJobName.unwrap(jobName): java.lang.String)
      .status(status.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .jobType(jobType.unwrap)
      .evaluationTaskTypesWithStrings(evaluationTaskTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .modelIdentifiers(modelIdentifiers.map { item =>
        EvaluationModelIdentifier.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.EvaluationSummary.ReadOnly =
    zio.aws.bedrock.model.EvaluationSummary.wrap(buildAwsValue())
}
object EvaluationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.EvaluationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.EvaluationSummary =
      zio.aws.bedrock.model.EvaluationSummary(
        jobArn,
        jobName,
        status,
        creationTime,
        jobType,
        evaluationTaskTypes,
        modelIdentifiers
      )
    def jobArn: EvaluationJobArn
    def jobName: EvaluationJobName
    def status: zio.aws.bedrock.model.EvaluationJobStatus
    def creationTime: Timestamp
    def jobType: zio.aws.bedrock.model.EvaluationJobType
    def evaluationTaskTypes: List[zio.aws.bedrock.model.EvaluationTaskType]
    def modelIdentifiers: List[EvaluationModelIdentifier]
    def getJobArn: ZIO[Any, Nothing, EvaluationJobArn] = ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, Nothing, EvaluationJobName] = ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationJobStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getJobType: ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationJobType] =
      ZIO.succeed(jobType)
    def getEvaluationTaskTypes
        : ZIO[Any, Nothing, List[zio.aws.bedrock.model.EvaluationTaskType]] =
      ZIO.succeed(evaluationTaskTypes)
    def getModelIdentifiers
        : ZIO[Any, Nothing, List[EvaluationModelIdentifier]] =
      ZIO.succeed(modelIdentifiers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationSummary
  ) extends zio.aws.bedrock.model.EvaluationSummary.ReadOnly {
    override val jobArn: EvaluationJobArn =
      zio.aws.bedrock.model.primitives.EvaluationJobArn(impl.jobArn())
    override val jobName: EvaluationJobName =
      zio.aws.bedrock.model.primitives.EvaluationJobName(impl.jobName())
    override val status: zio.aws.bedrock.model.EvaluationJobStatus =
      zio.aws.bedrock.model.EvaluationJobStatus.wrap(impl.status())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val jobType: zio.aws.bedrock.model.EvaluationJobType =
      zio.aws.bedrock.model.EvaluationJobType.wrap(impl.jobType())
    override val evaluationTaskTypes
        : List[zio.aws.bedrock.model.EvaluationTaskType] = impl
      .evaluationTaskTypes()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.EvaluationTaskType.wrap(item)
      }
      .toList
    override val modelIdentifiers: List[EvaluationModelIdentifier] = impl
      .modelIdentifiers()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.primitives.EvaluationModelIdentifier(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.EvaluationSummary
  ): zio.aws.bedrock.model.EvaluationSummary.ReadOnly = new Wrapper(impl)
}
