package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait EvaluationTaskType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.EvaluationTaskType
}
object EvaluationTaskType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.EvaluationTaskType
  ): zio.aws.bedrock.model.EvaluationTaskType = value match {
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.SUMMARIZATION =>
      val r = Summarization
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.CLASSIFICATION =>
      val r = Classification
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.QUESTION_AND_ANSWER =>
      val r = QuestionAndAnswer
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.GENERATION =>
      val r = Generation
      r
    case software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.CUSTOM =>
      val r = Custom
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.UNKNOWN_TO_SDK_VERSION
  }
  case object Summarization extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.SUMMARIZATION
  }
  case object Classification extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.CLASSIFICATION
  }
  case object QuestionAndAnswer
      extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.QUESTION_AND_ANSWER
  }
  case object Generation extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.GENERATION
  }
  case object Custom extends zio.aws.bedrock.model.EvaluationTaskType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.EvaluationTaskType =
      software.amazon.awssdk.services.bedrock.model.EvaluationTaskType.CUSTOM
  }
}
