package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait FineTuningJobStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus
}
object FineTuningJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus
  ): zio.aws.bedrock.model.FineTuningJobStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.COMPLETED =>
      val r = Completed
      r
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.STOPPED =>
      val r = Stopped
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object InProgress extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.IN_PROGRESS
  }
  case object Completed extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.COMPLETED
  }
  case object Failed extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.FAILED
  }
  case object Stopping extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.STOPPING
  }
  case object Stopped extends zio.aws.bedrock.model.FineTuningJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus =
      software.amazon.awssdk.services.bedrock.model.FineTuningJobStatus.STOPPED
  }
}
