package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  BrandedName,
  BedrockModelId,
  FoundationModelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FoundationModelDetails(
    modelArn: FoundationModelArn,
    modelId: BedrockModelId,
    modelName: Optional[BrandedName] = Optional.Absent,
    providerName: Optional[BrandedName] = Optional.Absent,
    inputModalities: Optional[Iterable[zio.aws.bedrock.model.ModelModality]] =
      Optional.Absent,
    outputModalities: Optional[Iterable[zio.aws.bedrock.model.ModelModality]] =
      Optional.Absent,
    responseStreamingSupported: Optional[Boolean] = Optional.Absent,
    customizationsSupported: Optional[
      Iterable[zio.aws.bedrock.model.ModelCustomization]
    ] = Optional.Absent,
    inferenceTypesSupported: Optional[
      Iterable[zio.aws.bedrock.model.InferenceType]
    ] = Optional.Absent,
    modelLifecycle: Optional[zio.aws.bedrock.model.FoundationModelLifecycle] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.FoundationModelDetails = {
    import FoundationModelDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.FoundationModelDetails
      .builder()
      .modelArn(FoundationModelArn.unwrap(modelArn): java.lang.String)
      .modelId(BedrockModelId.unwrap(modelId): java.lang.String)
      .optionallyWith(
        modelName.map(value => BrandedName.unwrap(value): java.lang.String)
      )(_.modelName)
      .optionallyWith(
        providerName.map(value => BrandedName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        inputModalities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inputModalitiesWithStrings)
      .optionallyWith(
        outputModalities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.outputModalitiesWithStrings)
      .optionallyWith(
        responseStreamingSupported.map(value => value: java.lang.Boolean)
      )(_.responseStreamingSupported)
      .optionallyWith(
        customizationsSupported.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.customizationsSupportedWithStrings)
      .optionallyWith(
        inferenceTypesSupported.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.inferenceTypesSupportedWithStrings)
      .optionallyWith(modelLifecycle.map(value => value.buildAwsValue()))(
        _.modelLifecycle
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.FoundationModelDetails.ReadOnly =
    zio.aws.bedrock.model.FoundationModelDetails.wrap(buildAwsValue())
}
object FoundationModelDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.FoundationModelDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.FoundationModelDetails =
      zio.aws.bedrock.model.FoundationModelDetails(
        modelArn,
        modelId,
        modelName.map(value => value),
        providerName.map(value => value),
        inputModalities.map(value => value),
        outputModalities.map(value => value),
        responseStreamingSupported.map(value => value),
        customizationsSupported.map(value => value),
        inferenceTypesSupported.map(value => value),
        modelLifecycle.map(value => value.asEditable)
      )
    def modelArn: FoundationModelArn
    def modelId: BedrockModelId
    def modelName: Optional[BrandedName]
    def providerName: Optional[BrandedName]
    def inputModalities: Optional[List[zio.aws.bedrock.model.ModelModality]]
    def outputModalities: Optional[List[zio.aws.bedrock.model.ModelModality]]
    def responseStreamingSupported: Optional[Boolean]
    def customizationsSupported
        : Optional[List[zio.aws.bedrock.model.ModelCustomization]]
    def inferenceTypesSupported
        : Optional[List[zio.aws.bedrock.model.InferenceType]]
    def modelLifecycle
        : Optional[zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly]
    def getModelArn: ZIO[Any, Nothing, FoundationModelArn] =
      ZIO.succeed(modelArn)
    def getModelId: ZIO[Any, Nothing, BedrockModelId] = ZIO.succeed(modelId)
    def getModelName: ZIO[Any, AwsError, BrandedName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getProviderName: ZIO[Any, AwsError, BrandedName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getInputModalities
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.ModelModality]] =
      AwsError.unwrapOptionField("inputModalities", inputModalities)
    def getOutputModalities
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.ModelModality]] =
      AwsError.unwrapOptionField("outputModalities", outputModalities)
    def getResponseStreamingSupported: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "responseStreamingSupported",
        responseStreamingSupported
      )
    def getCustomizationsSupported
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.ModelCustomization]] =
      AwsError.unwrapOptionField(
        "customizationsSupported",
        customizationsSupported
      )
    def getInferenceTypesSupported
        : ZIO[Any, AwsError, List[zio.aws.bedrock.model.InferenceType]] =
      AwsError.unwrapOptionField(
        "inferenceTypesSupported",
        inferenceTypesSupported
      )
    def getModelLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly
    ] = AwsError.unwrapOptionField("modelLifecycle", modelLifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.FoundationModelDetails
  ) extends zio.aws.bedrock.model.FoundationModelDetails.ReadOnly {
    override val modelArn: FoundationModelArn =
      zio.aws.bedrock.model.primitives.FoundationModelArn(impl.modelArn())
    override val modelId: BedrockModelId =
      zio.aws.bedrock.model.primitives.BedrockModelId(impl.modelId())
    override val modelName: Optional[BrandedName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.bedrock.model.primitives.BrandedName(value))
    override val providerName: Optional[BrandedName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.bedrock.model.primitives.BrandedName(value))
    override val inputModalities
        : Optional[List[zio.aws.bedrock.model.ModelModality]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputModalities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ModelModality.wrap(item)
          }.toList
        )
    override val outputModalities
        : Optional[List[zio.aws.bedrock.model.ModelModality]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputModalities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ModelModality.wrap(item)
          }.toList
        )
    override val responseStreamingSupported: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseStreamingSupported())
        .map(value => value: Boolean)
    override val customizationsSupported
        : Optional[List[zio.aws.bedrock.model.ModelCustomization]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationsSupported())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ModelCustomization.wrap(item)
          }.toList
        )
    override val inferenceTypesSupported
        : Optional[List[zio.aws.bedrock.model.InferenceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceTypesSupported())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.InferenceType.wrap(item)
          }.toList
        )
    override val modelLifecycle
        : Optional[zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelLifecycle())
        .map(value =>
          zio.aws.bedrock.model.FoundationModelLifecycle.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.FoundationModelDetails
  ): zio.aws.bedrock.model.FoundationModelDetails.ReadOnly = new Wrapper(impl)
}
