package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FoundationModelLifecycle(
    status: zio.aws.bedrock.model.FoundationModelLifecycleStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle = {
    import FoundationModelLifecycle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly =
    zio.aws.bedrock.model.FoundationModelLifecycle.wrap(buildAwsValue())
}
object FoundationModelLifecycle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.FoundationModelLifecycle =
      zio.aws.bedrock.model.FoundationModelLifecycle(status)
    def status: zio.aws.bedrock.model.FoundationModelLifecycleStatus
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.FoundationModelLifecycleStatus
    ] = ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle
  ) extends zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly {
    override val status: zio.aws.bedrock.model.FoundationModelLifecycleStatus =
      zio.aws.bedrock.model.FoundationModelLifecycleStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycle
  ): zio.aws.bedrock.model.FoundationModelLifecycle.ReadOnly = new Wrapper(impl)
}
