package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait FoundationModelLifecycleStatus {
  def unwrap: software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus
}
object FoundationModelLifecycleStatus {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus
  ): zio.aws.bedrock.model.FoundationModelLifecycleStatus = value match {
    case software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.LEGACY =>
      val r = LEGACY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.FoundationModelLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus =
      software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE
      extends zio.aws.bedrock.model.FoundationModelLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus =
      software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.ACTIVE
  }
  case object LEGACY
      extends zio.aws.bedrock.model.FoundationModelLifecycleStatus {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus =
      software.amazon.awssdk.services.bedrock.model.FoundationModelLifecycleStatus.LEGACY
  }
}
