package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCustomModelRequest(modelIdentifier: ModelIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest = {
    import GetCustomModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest
      .builder()
      .modelIdentifier(
        ModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetCustomModelRequest.ReadOnly =
    zio.aws.bedrock.model.GetCustomModelRequest.wrap(buildAwsValue())
}
object GetCustomModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetCustomModelRequest =
      zio.aws.bedrock.model.GetCustomModelRequest(modelIdentifier)
    def modelIdentifier: ModelIdentifier
    def getModelIdentifier: ZIO[Any, Nothing, ModelIdentifier] =
      ZIO.succeed(modelIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest
  ) extends zio.aws.bedrock.model.GetCustomModelRequest.ReadOnly {
    override val modelIdentifier: ModelIdentifier =
      zio.aws.bedrock.model.primitives.ModelIdentifier(impl.modelIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetCustomModelRequest
  ): zio.aws.bedrock.model.GetCustomModelRequest.ReadOnly = new Wrapper(impl)
}
