package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  CustomModelName,
  ModelArn,
  Timestamp,
  JobName,
  KmsKeyArn,
  ModelCustomizationJobArn
}
import scala.jdk.CollectionConverters._
final case class GetCustomModelResponse(
    modelArn: ModelArn,
    modelName: CustomModelName,
    jobName: Optional[JobName] = Optional.Absent,
    jobArn: ModelCustomizationJobArn,
    baseModelArn: ModelArn,
    customizationType: Optional[zio.aws.bedrock.model.CustomizationType] =
      Optional.Absent,
    modelKmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    hyperParameters: Optional[Map[String, String]] = Optional.Absent,
    trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig,
    validationDataConfig: Optional[zio.aws.bedrock.model.ValidationDataConfig] =
      Optional.Absent,
    outputDataConfig: zio.aws.bedrock.model.OutputDataConfig,
    trainingMetrics: Optional[zio.aws.bedrock.model.TrainingMetrics] =
      Optional.Absent,
    validationMetrics: Optional[
      Iterable[zio.aws.bedrock.model.ValidatorMetric]
    ] = Optional.Absent,
    creationTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse = {
    import GetCustomModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse
      .builder()
      .modelArn(ModelArn.unwrap(modelArn): java.lang.String)
      .modelName(CustomModelName.unwrap(modelName): java.lang.String)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .jobArn(ModelCustomizationJobArn.unwrap(jobArn): java.lang.String)
      .baseModelArn(ModelArn.unwrap(baseModelArn): java.lang.String)
      .optionallyWith(customizationType.map(value => value.unwrap))(
        _.customizationType
      )
      .optionallyWith(
        modelKmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.modelKmsKeyArn)
      .optionallyWith(
        hyperParameters.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.hyperParameters)
      .trainingDataConfig(trainingDataConfig.buildAwsValue())
      .optionallyWith(validationDataConfig.map(value => value.buildAwsValue()))(
        _.validationDataConfig
      )
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(trainingMetrics.map(value => value.buildAwsValue()))(
        _.trainingMetrics
      )
      .optionallyWith(
        validationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationMetrics)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly =
    zio.aws.bedrock.model.GetCustomModelResponse.wrap(buildAwsValue())
}
object GetCustomModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetCustomModelResponse =
      zio.aws.bedrock.model.GetCustomModelResponse(
        modelArn,
        modelName,
        jobName.map(value => value),
        jobArn,
        baseModelArn,
        customizationType.map(value => value),
        modelKmsKeyArn.map(value => value),
        hyperParameters.map(value => value),
        trainingDataConfig.asEditable,
        validationDataConfig.map(value => value.asEditable),
        outputDataConfig.asEditable,
        trainingMetrics.map(value => value.asEditable),
        validationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime
      )
    def modelArn: ModelArn
    def modelName: CustomModelName
    def jobName: Optional[JobName]
    def jobArn: ModelCustomizationJobArn
    def baseModelArn: ModelArn
    def customizationType: Optional[zio.aws.bedrock.model.CustomizationType]
    def modelKmsKeyArn: Optional[KmsKeyArn]
    def hyperParameters: Optional[Map[String, String]]
    def trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig.ReadOnly
    def validationDataConfig
        : Optional[zio.aws.bedrock.model.ValidationDataConfig.ReadOnly]
    def outputDataConfig: zio.aws.bedrock.model.OutputDataConfig.ReadOnly
    def trainingMetrics
        : Optional[zio.aws.bedrock.model.TrainingMetrics.ReadOnly]
    def validationMetrics
        : Optional[List[zio.aws.bedrock.model.ValidatorMetric.ReadOnly]]
    def creationTime: Timestamp
    def getModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(modelArn)
    def getModelName: ZIO[Any, Nothing, CustomModelName] =
      ZIO.succeed(modelName)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobArn: ZIO[Any, Nothing, ModelCustomizationJobArn] =
      ZIO.succeed(jobArn)
    def getBaseModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(baseModelArn)
    def getCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CustomizationType] =
      AwsError.unwrapOptionField("customizationType", customizationType)
    def getModelKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("modelKmsKeyArn", modelKmsKeyArn)
    def getHyperParameters: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("hyperParameters", hyperParameters)
    def getTrainingDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.TrainingDataConfig.ReadOnly] =
      ZIO.succeed(trainingDataConfig)
    def getValidationDataConfig: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.ValidationDataConfig.ReadOnly
    ] = AwsError.unwrapOptionField("validationDataConfig", validationDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getTrainingMetrics
        : ZIO[Any, AwsError, zio.aws.bedrock.model.TrainingMetrics.ReadOnly] =
      AwsError.unwrapOptionField("trainingMetrics", trainingMetrics)
    def getValidationMetrics: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ValidatorMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("validationMetrics", validationMetrics)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse
  ) extends zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly {
    override val modelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.modelArn())
    override val modelName: CustomModelName =
      zio.aws.bedrock.model.primitives.CustomModelName(impl.modelName())
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.bedrock.model.primitives.JobName(value))
    override val jobArn: ModelCustomizationJobArn =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobArn(impl.jobArn())
    override val baseModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.baseModelArn())
    override val customizationType
        : Optional[zio.aws.bedrock.model.CustomizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationType())
        .map(value => zio.aws.bedrock.model.CustomizationType.wrap(value))
    override val modelKmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyArn())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
    override val hyperParameters: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hyperParameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val trainingDataConfig
        : zio.aws.bedrock.model.TrainingDataConfig.ReadOnly =
      zio.aws.bedrock.model.TrainingDataConfig.wrap(impl.trainingDataConfig())
    override val validationDataConfig
        : Optional[zio.aws.bedrock.model.ValidationDataConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationDataConfig())
        .map(value => zio.aws.bedrock.model.ValidationDataConfig.wrap(value))
    override val outputDataConfig
        : zio.aws.bedrock.model.OutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val trainingMetrics
        : Optional[zio.aws.bedrock.model.TrainingMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingMetrics())
        .map(value => zio.aws.bedrock.model.TrainingMetrics.wrap(value))
    override val validationMetrics
        : Optional[List[zio.aws.bedrock.model.ValidatorMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ValidatorMetric.wrap(item)
          }.toList
        )
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetCustomModelResponse
  ): zio.aws.bedrock.model.GetCustomModelResponse.ReadOnly = new Wrapper(impl)
}
