package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.EvaluationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetEvaluationJobRequest(
    jobIdentifier: EvaluationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest = {
    import GetEvaluationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest
      .builder()
      .jobIdentifier(
        EvaluationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetEvaluationJobRequest.ReadOnly =
    zio.aws.bedrock.model.GetEvaluationJobRequest.wrap(buildAwsValue())
}
object GetEvaluationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetEvaluationJobRequest =
      zio.aws.bedrock.model.GetEvaluationJobRequest(jobIdentifier)
    def jobIdentifier: EvaluationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, EvaluationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest
  ) extends zio.aws.bedrock.model.GetEvaluationJobRequest.ReadOnly {
    override val jobIdentifier: EvaluationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .EvaluationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetEvaluationJobRequest
  ): zio.aws.bedrock.model.GetEvaluationJobRequest.ReadOnly = new Wrapper(impl)
}
