package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ErrorMessage,
  EvaluationJobDescription,
  RoleArn,
  Timestamp,
  EvaluationJobName,
  KmsKeyId,
  EvaluationJobArn
}
import scala.jdk.CollectionConverters._
final case class GetEvaluationJobResponse(
    jobName: EvaluationJobName,
    status: zio.aws.bedrock.model.EvaluationJobStatus,
    jobArn: EvaluationJobArn,
    jobDescription: Optional[EvaluationJobDescription] = Optional.Absent,
    roleArn: RoleArn,
    customerEncryptionKeyId: Optional[KmsKeyId] = Optional.Absent,
    jobType: zio.aws.bedrock.model.EvaluationJobType,
    evaluationConfig: zio.aws.bedrock.model.EvaluationConfig,
    inferenceConfig: zio.aws.bedrock.model.EvaluationInferenceConfig,
    outputDataConfig: zio.aws.bedrock.model.EvaluationOutputDataConfig,
    creationTime: Timestamp,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    failureMessages: Optional[Iterable[ErrorMessage]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse = {
    import GetEvaluationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse
      .builder()
      .jobName(EvaluationJobName.unwrap(jobName): java.lang.String)
      .status(status.unwrap)
      .jobArn(EvaluationJobArn.unwrap(jobArn): java.lang.String)
      .optionallyWith(
        jobDescription.map(value =>
          EvaluationJobDescription.unwrap(value): java.lang.String
        )
      )(_.jobDescription)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        customerEncryptionKeyId.map(value =>
          KmsKeyId.unwrap(value): java.lang.String
        )
      )(_.customerEncryptionKeyId)
      .jobType(jobType.unwrap)
      .evaluationConfig(evaluationConfig.buildAwsValue())
      .inferenceConfig(inferenceConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        failureMessages.map(value =>
          value.map { item =>
            ErrorMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureMessages)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly =
    zio.aws.bedrock.model.GetEvaluationJobResponse.wrap(buildAwsValue())
}
object GetEvaluationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetEvaluationJobResponse =
      zio.aws.bedrock.model.GetEvaluationJobResponse(
        jobName,
        status,
        jobArn,
        jobDescription.map(value => value),
        roleArn,
        customerEncryptionKeyId.map(value => value),
        jobType,
        evaluationConfig.asEditable,
        inferenceConfig.asEditable,
        outputDataConfig.asEditable,
        creationTime,
        lastModifiedTime.map(value => value),
        failureMessages.map(value => value)
      )
    def jobName: EvaluationJobName
    def status: zio.aws.bedrock.model.EvaluationJobStatus
    def jobArn: EvaluationJobArn
    def jobDescription: Optional[EvaluationJobDescription]
    def roleArn: RoleArn
    def customerEncryptionKeyId: Optional[KmsKeyId]
    def jobType: zio.aws.bedrock.model.EvaluationJobType
    def evaluationConfig: zio.aws.bedrock.model.EvaluationConfig.ReadOnly
    def inferenceConfig
        : zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly
    def outputDataConfig
        : zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly
    def creationTime: Timestamp
    def lastModifiedTime: Optional[Timestamp]
    def failureMessages: Optional[List[ErrorMessage]]
    def getJobName: ZIO[Any, Nothing, EvaluationJobName] = ZIO.succeed(jobName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationJobStatus] =
      ZIO.succeed(status)
    def getJobArn: ZIO[Any, Nothing, EvaluationJobArn] = ZIO.succeed(jobArn)
    def getJobDescription: ZIO[Any, AwsError, EvaluationJobDescription] =
      AwsError.unwrapOptionField("jobDescription", jobDescription)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getCustomerEncryptionKeyId: ZIO[Any, AwsError, KmsKeyId] = AwsError
      .unwrapOptionField("customerEncryptionKeyId", customerEncryptionKeyId)
    def getJobType: ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationJobType] =
      ZIO.succeed(jobType)
    def getEvaluationConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.EvaluationConfig.ReadOnly] =
      ZIO.succeed(evaluationConfig)
    def getInferenceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly
    ] = ZIO.succeed(inferenceConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getFailureMessages: ZIO[Any, AwsError, List[ErrorMessage]] =
      AwsError.unwrapOptionField("failureMessages", failureMessages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse
  ) extends zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly {
    override val jobName: EvaluationJobName =
      zio.aws.bedrock.model.primitives.EvaluationJobName(impl.jobName())
    override val status: zio.aws.bedrock.model.EvaluationJobStatus =
      zio.aws.bedrock.model.EvaluationJobStatus.wrap(impl.status())
    override val jobArn: EvaluationJobArn =
      zio.aws.bedrock.model.primitives.EvaluationJobArn(impl.jobArn())
    override val jobDescription: Optional[EvaluationJobDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobDescription())
        .map(value =>
          zio.aws.bedrock.model.primitives.EvaluationJobDescription(value)
        )
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val customerEncryptionKeyId: Optional[KmsKeyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerEncryptionKeyId())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyId(value))
    override val jobType: zio.aws.bedrock.model.EvaluationJobType =
      zio.aws.bedrock.model.EvaluationJobType.wrap(impl.jobType())
    override val evaluationConfig
        : zio.aws.bedrock.model.EvaluationConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationConfig.wrap(impl.evaluationConfig())
    override val inferenceConfig
        : zio.aws.bedrock.model.EvaluationInferenceConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationInferenceConfig
        .wrap(impl.inferenceConfig())
    override val outputDataConfig
        : zio.aws.bedrock.model.EvaluationOutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.EvaluationOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val failureMessages: Optional[List[ErrorMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureMessages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.primitives.ErrorMessage(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetEvaluationJobResponse
  ): zio.aws.bedrock.model.GetEvaluationJobResponse.ReadOnly = new Wrapper(impl)
}
