package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFoundationModelRequest(modelIdentifier: ModelIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest = {
    import GetFoundationModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest
      .builder()
      .modelIdentifier(
        ModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetFoundationModelRequest.ReadOnly =
    zio.aws.bedrock.model.GetFoundationModelRequest.wrap(buildAwsValue())
}
object GetFoundationModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetFoundationModelRequest =
      zio.aws.bedrock.model.GetFoundationModelRequest(modelIdentifier)
    def modelIdentifier: ModelIdentifier
    def getModelIdentifier: ZIO[Any, Nothing, ModelIdentifier] =
      ZIO.succeed(modelIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest
  ) extends zio.aws.bedrock.model.GetFoundationModelRequest.ReadOnly {
    override val modelIdentifier: ModelIdentifier =
      zio.aws.bedrock.model.primitives.ModelIdentifier(impl.modelIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetFoundationModelRequest
  ): zio.aws.bedrock.model.GetFoundationModelRequest.ReadOnly = new Wrapper(
    impl
  )
}
