package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFoundationModelResponse(
    modelDetails: Optional[zio.aws.bedrock.model.FoundationModelDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse = {
    import GetFoundationModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse
      .builder()
      .optionallyWith(modelDetails.map(value => value.buildAwsValue()))(
        _.modelDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly =
    zio.aws.bedrock.model.GetFoundationModelResponse.wrap(buildAwsValue())
}
object GetFoundationModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetFoundationModelResponse =
      zio.aws.bedrock.model
        .GetFoundationModelResponse(modelDetails.map(value => value.asEditable))
    def modelDetails
        : Optional[zio.aws.bedrock.model.FoundationModelDetails.ReadOnly]
    def getModelDetails: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.FoundationModelDetails.ReadOnly
    ] = AwsError.unwrapOptionField("modelDetails", modelDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse
  ) extends zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly {
    override val modelDetails
        : Optional[zio.aws.bedrock.model.FoundationModelDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDetails())
        .map(value => zio.aws.bedrock.model.FoundationModelDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetFoundationModelResponse
  ): zio.aws.bedrock.model.GetFoundationModelResponse.ReadOnly = new Wrapper(
    impl
  )
}
