package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{GuardrailVersion, GuardrailIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGuardrailRequest(
    guardrailIdentifier: GuardrailIdentifier,
    guardrailVersion: Optional[GuardrailVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest = {
    import GetGuardrailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest
      .builder()
      .guardrailIdentifier(
        GuardrailIdentifier.unwrap(guardrailIdentifier): java.lang.String
      )
      .optionallyWith(
        guardrailVersion.map(value =>
          GuardrailVersion.unwrap(value): java.lang.String
        )
      )(_.guardrailVersion)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetGuardrailRequest.ReadOnly =
    zio.aws.bedrock.model.GetGuardrailRequest.wrap(buildAwsValue())
}
object GetGuardrailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetGuardrailRequest =
      zio.aws.bedrock.model.GetGuardrailRequest(
        guardrailIdentifier,
        guardrailVersion.map(value => value)
      )
    def guardrailIdentifier: GuardrailIdentifier
    def guardrailVersion: Optional[GuardrailVersion]
    def getGuardrailIdentifier: ZIO[Any, Nothing, GuardrailIdentifier] =
      ZIO.succeed(guardrailIdentifier)
    def getGuardrailVersion: ZIO[Any, AwsError, GuardrailVersion] =
      AwsError.unwrapOptionField("guardrailVersion", guardrailVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest
  ) extends zio.aws.bedrock.model.GetGuardrailRequest.ReadOnly {
    override val guardrailIdentifier: GuardrailIdentifier =
      zio.aws.bedrock.model.primitives
        .GuardrailIdentifier(impl.guardrailIdentifier())
    override val guardrailVersion: Optional[GuardrailVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardrailVersion())
        .map(value => zio.aws.bedrock.model.primitives.GuardrailVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetGuardrailRequest
  ): zio.aws.bedrock.model.GetGuardrailRequest.ReadOnly = new Wrapper(impl)
}
