package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  GuardrailArn,
  GuardrailId,
  GuardrailName,
  GuardrailFailureRecommendation,
  GuardrailBlockedMessaging,
  Timestamp,
  GuardrailDescription,
  GuardrailStatusReason,
  KmsKeyArn,
  GuardrailVersion
}
import scala.jdk.CollectionConverters._
final case class GetGuardrailResponse(
    name: GuardrailName,
    description: Optional[GuardrailDescription] = Optional.Absent,
    guardrailId: GuardrailId,
    guardrailArn: GuardrailArn,
    version: GuardrailVersion,
    status: zio.aws.bedrock.model.GuardrailStatus,
    topicPolicy: Optional[zio.aws.bedrock.model.GuardrailTopicPolicy] =
      Optional.Absent,
    contentPolicy: Optional[zio.aws.bedrock.model.GuardrailContentPolicy] =
      Optional.Absent,
    wordPolicy: Optional[zio.aws.bedrock.model.GuardrailWordPolicy] =
      Optional.Absent,
    sensitiveInformationPolicy: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy
    ] = Optional.Absent,
    contextualGroundingPolicy: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicy
    ] = Optional.Absent,
    createdAt: Timestamp,
    updatedAt: Timestamp,
    statusReasons: Optional[Iterable[GuardrailStatusReason]] = Optional.Absent,
    failureRecommendations: Optional[Iterable[GuardrailFailureRecommendation]] =
      Optional.Absent,
    blockedInputMessaging: GuardrailBlockedMessaging,
    blockedOutputsMessaging: GuardrailBlockedMessaging,
    kmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse = {
    import GetGuardrailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse
      .builder()
      .name(GuardrailName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GuardrailDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .guardrailId(GuardrailId.unwrap(guardrailId): java.lang.String)
      .guardrailArn(GuardrailArn.unwrap(guardrailArn): java.lang.String)
      .version(GuardrailVersion.unwrap(version): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(topicPolicy.map(value => value.buildAwsValue()))(
        _.topicPolicy
      )
      .optionallyWith(contentPolicy.map(value => value.buildAwsValue()))(
        _.contentPolicy
      )
      .optionallyWith(wordPolicy.map(value => value.buildAwsValue()))(
        _.wordPolicy
      )
      .optionallyWith(
        sensitiveInformationPolicy.map(value => value.buildAwsValue())
      )(_.sensitiveInformationPolicy)
      .optionallyWith(
        contextualGroundingPolicy.map(value => value.buildAwsValue())
      )(_.contextualGroundingPolicy)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .updatedAt(Timestamp.unwrap(updatedAt): Instant)
      .optionallyWith(
        statusReasons.map(value =>
          value.map { item =>
            GuardrailStatusReason.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.statusReasons)
      .optionallyWith(
        failureRecommendations.map(value =>
          value.map { item =>
            GuardrailFailureRecommendation.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.failureRecommendations)
      .blockedInputMessaging(
        GuardrailBlockedMessaging.unwrap(
          blockedInputMessaging
        ): java.lang.String
      )
      .blockedOutputsMessaging(
        GuardrailBlockedMessaging.unwrap(
          blockedOutputsMessaging
        ): java.lang.String
      )
      .optionallyWith(
        kmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetGuardrailResponse.ReadOnly =
    zio.aws.bedrock.model.GetGuardrailResponse.wrap(buildAwsValue())
}
object GetGuardrailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetGuardrailResponse =
      zio.aws.bedrock.model.GetGuardrailResponse(
        name,
        description.map(value => value),
        guardrailId,
        guardrailArn,
        version,
        status,
        topicPolicy.map(value => value.asEditable),
        contentPolicy.map(value => value.asEditable),
        wordPolicy.map(value => value.asEditable),
        sensitiveInformationPolicy.map(value => value.asEditable),
        contextualGroundingPolicy.map(value => value.asEditable),
        createdAt,
        updatedAt,
        statusReasons.map(value => value),
        failureRecommendations.map(value => value),
        blockedInputMessaging,
        blockedOutputsMessaging,
        kmsKeyArn.map(value => value)
      )
    def name: GuardrailName
    def description: Optional[GuardrailDescription]
    def guardrailId: GuardrailId
    def guardrailArn: GuardrailArn
    def version: GuardrailVersion
    def status: zio.aws.bedrock.model.GuardrailStatus
    def topicPolicy
        : Optional[zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly]
    def contentPolicy
        : Optional[zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly]
    def wordPolicy: Optional[zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly]
    def sensitiveInformationPolicy: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly
    ]
    def contextualGroundingPolicy: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly
    ]
    def createdAt: Timestamp
    def updatedAt: Timestamp
    def statusReasons: Optional[List[GuardrailStatusReason]]
    def failureRecommendations: Optional[List[GuardrailFailureRecommendation]]
    def blockedInputMessaging: GuardrailBlockedMessaging
    def blockedOutputsMessaging: GuardrailBlockedMessaging
    def kmsKeyArn: Optional[KmsKeyArn]
    def getName: ZIO[Any, Nothing, GuardrailName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, GuardrailDescription] =
      AwsError.unwrapOptionField("description", description)
    def getGuardrailId: ZIO[Any, Nothing, GuardrailId] =
      ZIO.succeed(guardrailId)
    def getGuardrailArn: ZIO[Any, Nothing, GuardrailArn] =
      ZIO.succeed(guardrailArn)
    def getVersion: ZIO[Any, Nothing, GuardrailVersion] = ZIO.succeed(version)
    def getStatus: ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailStatus] =
      ZIO.succeed(status)
    def getTopicPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("topicPolicy", topicPolicy)
    def getContentPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("contentPolicy", contentPolicy)
    def getWordPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("wordPolicy", wordPolicy)
    def getSensitiveInformationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sensitiveInformationPolicy",
      sensitiveInformationPolicy
    )
    def getContextualGroundingPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contextualGroundingPolicy",
      contextualGroundingPolicy
    )
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getUpdatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updatedAt)
    def getStatusReasons: ZIO[Any, AwsError, List[GuardrailStatusReason]] =
      AwsError.unwrapOptionField("statusReasons", statusReasons)
    def getFailureRecommendations
        : ZIO[Any, AwsError, List[GuardrailFailureRecommendation]] = AwsError
      .unwrapOptionField("failureRecommendations", failureRecommendations)
    def getBlockedInputMessaging: ZIO[Any, Nothing, GuardrailBlockedMessaging] =
      ZIO.succeed(blockedInputMessaging)
    def getBlockedOutputsMessaging
        : ZIO[Any, Nothing, GuardrailBlockedMessaging] =
      ZIO.succeed(blockedOutputsMessaging)
    def getKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse
  ) extends zio.aws.bedrock.model.GetGuardrailResponse.ReadOnly {
    override val name: GuardrailName =
      zio.aws.bedrock.model.primitives.GuardrailName(impl.name())
    override val description: Optional[GuardrailDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.GuardrailDescription(value)
        )
    override val guardrailId: GuardrailId =
      zio.aws.bedrock.model.primitives.GuardrailId(impl.guardrailId())
    override val guardrailArn: GuardrailArn =
      zio.aws.bedrock.model.primitives.GuardrailArn(impl.guardrailArn())
    override val version: GuardrailVersion =
      zio.aws.bedrock.model.primitives.GuardrailVersion(impl.version())
    override val status: zio.aws.bedrock.model.GuardrailStatus =
      zio.aws.bedrock.model.GuardrailStatus.wrap(impl.status())
    override val topicPolicy
        : Optional[zio.aws.bedrock.model.GuardrailTopicPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.topicPolicy())
        .map(value => zio.aws.bedrock.model.GuardrailTopicPolicy.wrap(value))
    override val contentPolicy
        : Optional[zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentPolicy())
        .map(value => zio.aws.bedrock.model.GuardrailContentPolicy.wrap(value))
    override val wordPolicy
        : Optional[zio.aws.bedrock.model.GuardrailWordPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wordPolicy())
        .map(value => zio.aws.bedrock.model.GuardrailWordPolicy.wrap(value))
    override val sensitiveInformationPolicy: Optional[
      zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sensitiveInformationPolicy())
      .map(value =>
        zio.aws.bedrock.model.GuardrailSensitiveInformationPolicy.wrap(value)
      )
    override val contextualGroundingPolicy: Optional[
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.contextualGroundingPolicy())
      .map(value =>
        zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.wrap(value)
      )
    override val createdAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.createdAt())
    override val updatedAt: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.updatedAt())
    override val statusReasons: Optional[List[GuardrailStatusReason]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReasons())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.primitives.GuardrailStatusReason(item)
          }.toList
        )
    override val failureRecommendations
        : Optional[List[GuardrailFailureRecommendation]] = zio.aws.core.internal
      .optionalFromNullable(impl.failureRecommendations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.primitives.GuardrailFailureRecommendation(item)
        }.toList
      )
    override val blockedInputMessaging: GuardrailBlockedMessaging =
      zio.aws.bedrock.model.primitives
        .GuardrailBlockedMessaging(impl.blockedInputMessaging())
    override val blockedOutputsMessaging: GuardrailBlockedMessaging =
      zio.aws.bedrock.model.primitives
        .GuardrailBlockedMessaging(impl.blockedOutputsMessaging())
    override val kmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyArn())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetGuardrailResponse
  ): zio.aws.bedrock.model.GetGuardrailResponse.ReadOnly = new Wrapper(impl)
}
