package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ImportedModelIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetImportedModelRequest(
    modelIdentifier: ImportedModelIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest = {
    import GetImportedModelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest
      .builder()
      .modelIdentifier(
        ImportedModelIdentifier.unwrap(modelIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetImportedModelRequest.ReadOnly =
    zio.aws.bedrock.model.GetImportedModelRequest.wrap(buildAwsValue())
}
object GetImportedModelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetImportedModelRequest =
      zio.aws.bedrock.model.GetImportedModelRequest(modelIdentifier)
    def modelIdentifier: ImportedModelIdentifier
    def getModelIdentifier: ZIO[Any, Nothing, ImportedModelIdentifier] =
      ZIO.succeed(modelIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest
  ) extends zio.aws.bedrock.model.GetImportedModelRequest.ReadOnly {
    override val modelIdentifier: ImportedModelIdentifier =
      zio.aws.bedrock.model.primitives
        .ImportedModelIdentifier(impl.modelIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetImportedModelRequest
  ): zio.aws.bedrock.model.GetImportedModelRequest.ReadOnly = new Wrapper(impl)
}
