package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  InstructSupported,
  ImportedModelName,
  Timestamp,
  ModelImportJobArn,
  ImportedModelArn,
  JobName,
  KmsKeyArn
}
import scala.jdk.CollectionConverters._
final case class GetImportedModelResponse(
    modelArn: Optional[ImportedModelArn] = Optional.Absent,
    modelName: Optional[ImportedModelName] = Optional.Absent,
    jobName: Optional[JobName] = Optional.Absent,
    jobArn: Optional[ModelImportJobArn] = Optional.Absent,
    modelDataSource: Optional[zio.aws.bedrock.model.ModelDataSource] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    modelArchitecture: Optional[String] = Optional.Absent,
    modelKmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    instructSupported: Optional[InstructSupported] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse = {
    import GetImportedModelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse
      .builder()
      .optionallyWith(
        modelArn.map(value => ImportedModelArn.unwrap(value): java.lang.String)
      )(_.modelArn)
      .optionallyWith(
        modelName.map(value =>
          ImportedModelName.unwrap(value): java.lang.String
        )
      )(_.modelName)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        jobArn.map(value => ModelImportJobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(modelDataSource.map(value => value.buildAwsValue()))(
        _.modelDataSource
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(modelArchitecture.map(value => value: java.lang.String))(
        _.modelArchitecture
      )
      .optionallyWith(
        modelKmsKeyArn.map(value => KmsKeyArn.unwrap(value): java.lang.String)
      )(_.modelKmsKeyArn)
      .optionallyWith(
        instructSupported.map(value =>
          InstructSupported.unwrap(value): java.lang.Boolean
        )
      )(_.instructSupported)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly =
    zio.aws.bedrock.model.GetImportedModelResponse.wrap(buildAwsValue())
}
object GetImportedModelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetImportedModelResponse =
      zio.aws.bedrock.model.GetImportedModelResponse(
        modelArn.map(value => value),
        modelName.map(value => value),
        jobName.map(value => value),
        jobArn.map(value => value),
        modelDataSource.map(value => value.asEditable),
        creationTime.map(value => value),
        modelArchitecture.map(value => value),
        modelKmsKeyArn.map(value => value),
        instructSupported.map(value => value)
      )
    def modelArn: Optional[ImportedModelArn]
    def modelName: Optional[ImportedModelName]
    def jobName: Optional[JobName]
    def jobArn: Optional[ModelImportJobArn]
    def modelDataSource
        : Optional[zio.aws.bedrock.model.ModelDataSource.ReadOnly]
    def creationTime: Optional[Timestamp]
    def modelArchitecture: Optional[String]
    def modelKmsKeyArn: Optional[KmsKeyArn]
    def instructSupported: Optional[InstructSupported]
    def getModelArn: ZIO[Any, AwsError, ImportedModelArn] =
      AwsError.unwrapOptionField("modelArn", modelArn)
    def getModelName: ZIO[Any, AwsError, ImportedModelName] =
      AwsError.unwrapOptionField("modelName", modelName)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getJobArn: ZIO[Any, AwsError, ModelImportJobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getModelDataSource
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelDataSource.ReadOnly] =
      AwsError.unwrapOptionField("modelDataSource", modelDataSource)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getModelArchitecture: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("modelArchitecture", modelArchitecture)
    def getModelKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("modelKmsKeyArn", modelKmsKeyArn)
    def getInstructSupported: ZIO[Any, AwsError, InstructSupported] =
      AwsError.unwrapOptionField("instructSupported", instructSupported)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse
  ) extends zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly {
    override val modelArn: Optional[ImportedModelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArn())
      .map(value => zio.aws.bedrock.model.primitives.ImportedModelArn(value))
    override val modelName: Optional[ImportedModelName] = zio.aws.core.internal
      .optionalFromNullable(impl.modelName())
      .map(value => zio.aws.bedrock.model.primitives.ImportedModelName(value))
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.bedrock.model.primitives.JobName(value))
    override val jobArn: Optional[ModelImportJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.bedrock.model.primitives.ModelImportJobArn(value))
    override val modelDataSource
        : Optional[zio.aws.bedrock.model.ModelDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDataSource())
        .map(value => zio.aws.bedrock.model.ModelDataSource.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val modelArchitecture: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.modelArchitecture())
      .map(value => value: String)
    override val modelKmsKeyArn: Optional[KmsKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.modelKmsKeyArn())
      .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
    override val instructSupported: Optional[InstructSupported] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instructSupported())
        .map(value => zio.aws.bedrock.model.primitives.InstructSupported(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetImportedModelResponse
  ): zio.aws.bedrock.model.GetImportedModelResponse.ReadOnly = new Wrapper(impl)
}
