package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.InferenceProfileIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetInferenceProfileRequest(
    inferenceProfileIdentifier: InferenceProfileIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest = {
    import GetInferenceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest
      .builder()
      .inferenceProfileIdentifier(
        InferenceProfileIdentifier.unwrap(
          inferenceProfileIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetInferenceProfileRequest.ReadOnly =
    zio.aws.bedrock.model.GetInferenceProfileRequest.wrap(buildAwsValue())
}
object GetInferenceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetInferenceProfileRequest =
      zio.aws.bedrock.model
        .GetInferenceProfileRequest(inferenceProfileIdentifier)
    def inferenceProfileIdentifier: InferenceProfileIdentifier
    def getInferenceProfileIdentifier
        : ZIO[Any, Nothing, InferenceProfileIdentifier] =
      ZIO.succeed(inferenceProfileIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest
  ) extends zio.aws.bedrock.model.GetInferenceProfileRequest.ReadOnly {
    override val inferenceProfileIdentifier: InferenceProfileIdentifier =
      zio.aws.bedrock.model.primitives
        .InferenceProfileIdentifier(impl.inferenceProfileIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetInferenceProfileRequest
  ): zio.aws.bedrock.model.GetInferenceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
