package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  InferenceProfileName,
  Timestamp,
  InferenceProfileArn,
  InferenceProfileDescription,
  InferenceProfileId
}
import scala.jdk.CollectionConverters._
final case class GetInferenceProfileResponse(
    inferenceProfileName: InferenceProfileName,
    models: Iterable[zio.aws.bedrock.model.InferenceProfileModel],
    description: Optional[InferenceProfileDescription] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    inferenceProfileArn: InferenceProfileArn,
    inferenceProfileId: InferenceProfileId,
    status: zio.aws.bedrock.model.InferenceProfileStatus,
    `type`: zio.aws.bedrock.model.InferenceProfileType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse = {
    import GetInferenceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse
      .builder()
      .inferenceProfileName(
        InferenceProfileName.unwrap(inferenceProfileName): java.lang.String
      )
      .models(models.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        description.map(value =>
          InferenceProfileDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .inferenceProfileArn(
        InferenceProfileArn.unwrap(inferenceProfileArn): java.lang.String
      )
      .inferenceProfileId(
        InferenceProfileId.unwrap(inferenceProfileId): java.lang.String
      )
      .status(status.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly =
    zio.aws.bedrock.model.GetInferenceProfileResponse.wrap(buildAwsValue())
}
object GetInferenceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetInferenceProfileResponse =
      zio.aws.bedrock.model.GetInferenceProfileResponse(
        inferenceProfileName,
        models.map { item =>
          item.asEditable
        },
        description.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        inferenceProfileArn,
        inferenceProfileId,
        status,
        `type`
      )
    def inferenceProfileName: InferenceProfileName
    def models: List[zio.aws.bedrock.model.InferenceProfileModel.ReadOnly]
    def description: Optional[InferenceProfileDescription]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def inferenceProfileArn: InferenceProfileArn
    def inferenceProfileId: InferenceProfileId
    def status: zio.aws.bedrock.model.InferenceProfileStatus
    def `type`: zio.aws.bedrock.model.InferenceProfileType
    def getInferenceProfileName: ZIO[Any, Nothing, InferenceProfileName] =
      ZIO.succeed(inferenceProfileName)
    def getModels: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.InferenceProfileModel.ReadOnly
    ]] = ZIO.succeed(models)
    def getDescription: ZIO[Any, AwsError, InferenceProfileDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getInferenceProfileArn: ZIO[Any, Nothing, InferenceProfileArn] =
      ZIO.succeed(inferenceProfileArn)
    def getInferenceProfileId: ZIO[Any, Nothing, InferenceProfileId] =
      ZIO.succeed(inferenceProfileId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.InferenceProfileStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, Nothing, zio.aws.bedrock.model.InferenceProfileType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse
  ) extends zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly {
    override val inferenceProfileName: InferenceProfileName =
      zio.aws.bedrock.model.primitives
        .InferenceProfileName(impl.inferenceProfileName())
    override val models
        : List[zio.aws.bedrock.model.InferenceProfileModel.ReadOnly] = impl
      .models()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.InferenceProfileModel.wrap(item)
      }
      .toList
    override val description: Optional[InferenceProfileDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives.InferenceProfileDescription(value)
        )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val inferenceProfileArn: InferenceProfileArn =
      zio.aws.bedrock.model.primitives
        .InferenceProfileArn(impl.inferenceProfileArn())
    override val inferenceProfileId: InferenceProfileId =
      zio.aws.bedrock.model.primitives
        .InferenceProfileId(impl.inferenceProfileId())
    override val status: zio.aws.bedrock.model.InferenceProfileStatus =
      zio.aws.bedrock.model.InferenceProfileStatus.wrap(impl.status())
    override val `type`: zio.aws.bedrock.model.InferenceProfileType =
      zio.aws.bedrock.model.InferenceProfileType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetInferenceProfileResponse
  ): zio.aws.bedrock.model.GetInferenceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
