package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelCopyJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetModelCopyJobRequest(jobArn: ModelCopyJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest = {
    import GetModelCopyJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest
      .builder()
      .jobArn(ModelCopyJobArn.unwrap(jobArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetModelCopyJobRequest.ReadOnly =
    zio.aws.bedrock.model.GetModelCopyJobRequest.wrap(buildAwsValue())
}
object GetModelCopyJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelCopyJobRequest =
      zio.aws.bedrock.model.GetModelCopyJobRequest(jobArn)
    def jobArn: ModelCopyJobArn
    def getJobArn: ZIO[Any, Nothing, ModelCopyJobArn] = ZIO.succeed(jobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest
  ) extends zio.aws.bedrock.model.GetModelCopyJobRequest.ReadOnly {
    override val jobArn: ModelCopyJobArn =
      zio.aws.bedrock.model.primitives.ModelCopyJobArn(impl.jobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCopyJobRequest
  ): zio.aws.bedrock.model.GetModelCopyJobRequest.ReadOnly = new Wrapper(impl)
}
