package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelCustomizationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetModelCustomizationJobRequest(
    jobIdentifier: ModelCustomizationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest = {
    import GetModelCustomizationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest
      .builder()
      .jobIdentifier(
        ModelCustomizationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GetModelCustomizationJobRequest.ReadOnly =
    zio.aws.bedrock.model.GetModelCustomizationJobRequest.wrap(buildAwsValue())
}
object GetModelCustomizationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelCustomizationJobRequest =
      zio.aws.bedrock.model.GetModelCustomizationJobRequest(jobIdentifier)
    def jobIdentifier: ModelCustomizationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, ModelCustomizationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest
  ) extends zio.aws.bedrock.model.GetModelCustomizationJobRequest.ReadOnly {
    override val jobIdentifier: ModelCustomizationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .ModelCustomizationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobRequest
  ): zio.aws.bedrock.model.GetModelCustomizationJobRequest.ReadOnly =
    new Wrapper(impl)
}
