package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ErrorMessage,
  RoleArn,
  CustomModelName,
  CustomModelArn,
  Timestamp,
  IdempotencyToken,
  JobName,
  FoundationModelArn,
  KmsKeyArn,
  ModelCustomizationJobArn
}
import scala.jdk.CollectionConverters._
final case class GetModelCustomizationJobResponse(
    jobArn: ModelCustomizationJobArn,
    jobName: JobName,
    outputModelName: CustomModelName,
    outputModelArn: Optional[CustomModelArn] = Optional.Absent,
    clientRequestToken: Optional[IdempotencyToken] = Optional.Absent,
    roleArn: RoleArn,
    status: Optional[zio.aws.bedrock.model.ModelCustomizationJobStatus] =
      Optional.Absent,
    failureMessage: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Timestamp,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    baseModelArn: FoundationModelArn,
    hyperParameters: Map[String, String],
    trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig,
    validationDataConfig: zio.aws.bedrock.model.ValidationDataConfig,
    outputDataConfig: zio.aws.bedrock.model.OutputDataConfig,
    customizationType: Optional[zio.aws.bedrock.model.CustomizationType] =
      Optional.Absent,
    outputModelKmsKeyArn: Optional[KmsKeyArn] = Optional.Absent,
    trainingMetrics: Optional[zio.aws.bedrock.model.TrainingMetrics] =
      Optional.Absent,
    validationMetrics: Optional[
      Iterable[zio.aws.bedrock.model.ValidatorMetric]
    ] = Optional.Absent,
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse = {
    import GetModelCustomizationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse
      .builder()
      .jobArn(ModelCustomizationJobArn.unwrap(jobArn): java.lang.String)
      .jobName(JobName.unwrap(jobName): java.lang.String)
      .outputModelName(
        CustomModelName.unwrap(outputModelName): java.lang.String
      )
      .optionallyWith(
        outputModelArn.map(value =>
          CustomModelArn.unwrap(value): java.lang.String
        )
      )(_.outputModelArn)
      .optionallyWith(
        clientRequestToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failureMessage.map(value =>
          ErrorMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .baseModelArn(FoundationModelArn.unwrap(baseModelArn): java.lang.String)
      .hyperParameters(
        hyperParameters
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .trainingDataConfig(trainingDataConfig.buildAwsValue())
      .validationDataConfig(validationDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(customizationType.map(value => value.unwrap))(
        _.customizationType
      )
      .optionallyWith(
        outputModelKmsKeyArn.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.outputModelKmsKeyArn)
      .optionallyWith(trainingMetrics.map(value => value.buildAwsValue()))(
        _.trainingMetrics
      )
      .optionallyWith(
        validationMetrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationMetrics)
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly =
    zio.aws.bedrock.model.GetModelCustomizationJobResponse.wrap(buildAwsValue())
}
object GetModelCustomizationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelCustomizationJobResponse =
      zio.aws.bedrock.model.GetModelCustomizationJobResponse(
        jobArn,
        jobName,
        outputModelName,
        outputModelArn.map(value => value),
        clientRequestToken.map(value => value),
        roleArn,
        status.map(value => value),
        failureMessage.map(value => value),
        creationTime,
        lastModifiedTime.map(value => value),
        endTime.map(value => value),
        baseModelArn,
        hyperParameters,
        trainingDataConfig.asEditable,
        validationDataConfig.asEditable,
        outputDataConfig.asEditable,
        customizationType.map(value => value),
        outputModelKmsKeyArn.map(value => value),
        trainingMetrics.map(value => value.asEditable),
        validationMetrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcConfig.map(value => value.asEditable)
      )
    def jobArn: ModelCustomizationJobArn
    def jobName: JobName
    def outputModelName: CustomModelName
    def outputModelArn: Optional[CustomModelArn]
    def clientRequestToken: Optional[IdempotencyToken]
    def roleArn: RoleArn
    def status: Optional[zio.aws.bedrock.model.ModelCustomizationJobStatus]
    def failureMessage: Optional[ErrorMessage]
    def creationTime: Timestamp
    def lastModifiedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def baseModelArn: FoundationModelArn
    def hyperParameters: Map[String, String]
    def trainingDataConfig: zio.aws.bedrock.model.TrainingDataConfig.ReadOnly
    def validationDataConfig
        : zio.aws.bedrock.model.ValidationDataConfig.ReadOnly
    def outputDataConfig: zio.aws.bedrock.model.OutputDataConfig.ReadOnly
    def customizationType: Optional[zio.aws.bedrock.model.CustomizationType]
    def outputModelKmsKeyArn: Optional[KmsKeyArn]
    def trainingMetrics
        : Optional[zio.aws.bedrock.model.TrainingMetrics.ReadOnly]
    def validationMetrics
        : Optional[List[zio.aws.bedrock.model.ValidatorMetric.ReadOnly]]
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def getJobArn: ZIO[Any, Nothing, ModelCustomizationJobArn] =
      ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, Nothing, JobName] = ZIO.succeed(jobName)
    def getOutputModelName: ZIO[Any, Nothing, CustomModelName] =
      ZIO.succeed(outputModelName)
    def getOutputModelArn: ZIO[Any, AwsError, CustomModelArn] =
      AwsError.unwrapOptionField("outputModelArn", outputModelArn)
    def getClientRequestToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.bedrock.model.ModelCustomizationJobStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getBaseModelArn: ZIO[Any, Nothing, FoundationModelArn] =
      ZIO.succeed(baseModelArn)
    def getHyperParameters: ZIO[Any, Nothing, Map[String, String]] =
      ZIO.succeed(hyperParameters)
    def getTrainingDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.TrainingDataConfig.ReadOnly] =
      ZIO.succeed(trainingDataConfig)
    def getValidationDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.ValidationDataConfig.ReadOnly
    ] = ZIO.succeed(validationDataConfig)
    def getOutputDataConfig
        : ZIO[Any, Nothing, zio.aws.bedrock.model.OutputDataConfig.ReadOnly] =
      ZIO.succeed(outputDataConfig)
    def getCustomizationType
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CustomizationType] =
      AwsError.unwrapOptionField("customizationType", customizationType)
    def getOutputModelKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] =
      AwsError.unwrapOptionField("outputModelKmsKeyArn", outputModelKmsKeyArn)
    def getTrainingMetrics
        : ZIO[Any, AwsError, zio.aws.bedrock.model.TrainingMetrics.ReadOnly] =
      AwsError.unwrapOptionField("trainingMetrics", trainingMetrics)
    def getValidationMetrics: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.ValidatorMetric.ReadOnly
    ]] = AwsError.unwrapOptionField("validationMetrics", validationMetrics)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse
  ) extends zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly {
    override val jobArn: ModelCustomizationJobArn =
      zio.aws.bedrock.model.primitives.ModelCustomizationJobArn(impl.jobArn())
    override val jobName: JobName =
      zio.aws.bedrock.model.primitives.JobName(impl.jobName())
    override val outputModelName: CustomModelName =
      zio.aws.bedrock.model.primitives.CustomModelName(impl.outputModelName())
    override val outputModelArn: Optional[CustomModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputModelArn())
        .map(value => zio.aws.bedrock.model.primitives.CustomModelArn(value))
    override val clientRequestToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.bedrock.model.primitives.IdempotencyToken(value))
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val status
        : Optional[zio.aws.bedrock.model.ModelCustomizationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.bedrock.model.ModelCustomizationJobStatus.wrap(value)
        )
    override val failureMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => zio.aws.bedrock.model.primitives.ErrorMessage(value))
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val baseModelArn: FoundationModelArn =
      zio.aws.bedrock.model.primitives.FoundationModelArn(impl.baseModelArn())
    override val hyperParameters: Map[String, String] = impl
      .hyperParameters()
      .asScala
      .map({ case (key, value) =>
        (key: String) -> (value: String)
      })
      .toMap
    override val trainingDataConfig
        : zio.aws.bedrock.model.TrainingDataConfig.ReadOnly =
      zio.aws.bedrock.model.TrainingDataConfig.wrap(impl.trainingDataConfig())
    override val validationDataConfig
        : zio.aws.bedrock.model.ValidationDataConfig.ReadOnly =
      zio.aws.bedrock.model.ValidationDataConfig
        .wrap(impl.validationDataConfig())
    override val outputDataConfig
        : zio.aws.bedrock.model.OutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.OutputDataConfig.wrap(impl.outputDataConfig())
    override val customizationType
        : Optional[zio.aws.bedrock.model.CustomizationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customizationType())
        .map(value => zio.aws.bedrock.model.CustomizationType.wrap(value))
    override val outputModelKmsKeyArn: Optional[KmsKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputModelKmsKeyArn())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
    override val trainingMetrics
        : Optional[zio.aws.bedrock.model.TrainingMetrics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trainingMetrics())
        .map(value => zio.aws.bedrock.model.TrainingMetrics.wrap(value))
    override val validationMetrics
        : Optional[List[zio.aws.bedrock.model.ValidatorMetric.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationMetrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.bedrock.model.ValidatorMetric.wrap(item)
          }.toList
        )
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelCustomizationJobResponse
  ): zio.aws.bedrock.model.GetModelCustomizationJobResponse.ReadOnly =
    new Wrapper(impl)
}
