package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelImportJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetModelImportJobRequest(
    jobIdentifier: ModelImportJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest = {
    import GetModelImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest
      .builder()
      .jobIdentifier(
        ModelImportJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetModelImportJobRequest.ReadOnly =
    zio.aws.bedrock.model.GetModelImportJobRequest.wrap(buildAwsValue())
}
object GetModelImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelImportJobRequest =
      zio.aws.bedrock.model.GetModelImportJobRequest(jobIdentifier)
    def jobIdentifier: ModelImportJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, ModelImportJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest
  ) extends zio.aws.bedrock.model.GetModelImportJobRequest.ReadOnly {
    override val jobIdentifier: ModelImportJobIdentifier =
      zio.aws.bedrock.model.primitives
        .ModelImportJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelImportJobRequest
  ): zio.aws.bedrock.model.GetModelImportJobRequest.ReadOnly = new Wrapper(impl)
}
