package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ErrorMessage,
  RoleArn,
  ImportedModelName,
  Timestamp,
  ModelImportJobArn,
  ImportedModelArn,
  JobName,
  KmsKeyArn
}
import scala.jdk.CollectionConverters._
final case class GetModelImportJobResponse(
    jobArn: Optional[ModelImportJobArn] = Optional.Absent,
    jobName: Optional[JobName] = Optional.Absent,
    importedModelName: Optional[ImportedModelName] = Optional.Absent,
    importedModelArn: Optional[ImportedModelArn] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    modelDataSource: Optional[zio.aws.bedrock.model.ModelDataSource] =
      Optional.Absent,
    status: Optional[zio.aws.bedrock.model.ModelImportJobStatus] =
      Optional.Absent,
    failureMessage: Optional[ErrorMessage] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent,
    importedModelKmsKeyArn: Optional[KmsKeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse = {
    import GetModelImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse
      .builder()
      .optionallyWith(
        jobArn.map(value => ModelImportJobArn.unwrap(value): java.lang.String)
      )(_.jobArn)
      .optionallyWith(
        jobName.map(value => JobName.unwrap(value): java.lang.String)
      )(_.jobName)
      .optionallyWith(
        importedModelName.map(value =>
          ImportedModelName.unwrap(value): java.lang.String
        )
      )(_.importedModelName)
      .optionallyWith(
        importedModelArn.map(value =>
          ImportedModelArn.unwrap(value): java.lang.String
        )
      )(_.importedModelArn)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(modelDataSource.map(value => value.buildAwsValue()))(
        _.modelDataSource
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failureMessage.map(value =>
          ErrorMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        importedModelKmsKeyArn.map(value =>
          KmsKeyArn.unwrap(value): java.lang.String
        )
      )(_.importedModelKmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly =
    zio.aws.bedrock.model.GetModelImportJobResponse.wrap(buildAwsValue())
}
object GetModelImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelImportJobResponse =
      zio.aws.bedrock.model.GetModelImportJobResponse(
        jobArn.map(value => value),
        jobName.map(value => value),
        importedModelName.map(value => value),
        importedModelArn.map(value => value),
        roleArn.map(value => value),
        modelDataSource.map(value => value.asEditable),
        status.map(value => value),
        failureMessage.map(value => value),
        creationTime.map(value => value),
        lastModifiedTime.map(value => value),
        endTime.map(value => value),
        vpcConfig.map(value => value.asEditable),
        importedModelKmsKeyArn.map(value => value)
      )
    def jobArn: Optional[ModelImportJobArn]
    def jobName: Optional[JobName]
    def importedModelName: Optional[ImportedModelName]
    def importedModelArn: Optional[ImportedModelArn]
    def roleArn: Optional[RoleArn]
    def modelDataSource
        : Optional[zio.aws.bedrock.model.ModelDataSource.ReadOnly]
    def status: Optional[zio.aws.bedrock.model.ModelImportJobStatus]
    def failureMessage: Optional[ErrorMessage]
    def creationTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def importedModelKmsKeyArn: Optional[KmsKeyArn]
    def getJobArn: ZIO[Any, AwsError, ModelImportJobArn] =
      AwsError.unwrapOptionField("jobArn", jobArn)
    def getJobName: ZIO[Any, AwsError, JobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getImportedModelName: ZIO[Any, AwsError, ImportedModelName] =
      AwsError.unwrapOptionField("importedModelName", importedModelName)
    def getImportedModelArn: ZIO[Any, AwsError, ImportedModelArn] =
      AwsError.unwrapOptionField("importedModelArn", importedModelArn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getModelDataSource
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelDataSource.ReadOnly] =
      AwsError.unwrapOptionField("modelDataSource", modelDataSource)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelImportJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getFailureMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getImportedModelKmsKeyArn: ZIO[Any, AwsError, KmsKeyArn] = AwsError
      .unwrapOptionField("importedModelKmsKeyArn", importedModelKmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse
  ) extends zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly {
    override val jobArn: Optional[ModelImportJobArn] = zio.aws.core.internal
      .optionalFromNullable(impl.jobArn())
      .map(value => zio.aws.bedrock.model.primitives.ModelImportJobArn(value))
    override val jobName: Optional[JobName] = zio.aws.core.internal
      .optionalFromNullable(impl.jobName())
      .map(value => zio.aws.bedrock.model.primitives.JobName(value))
    override val importedModelName: Optional[ImportedModelName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelName())
        .map(value => zio.aws.bedrock.model.primitives.ImportedModelName(value))
    override val importedModelArn: Optional[ImportedModelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelArn())
        .map(value => zio.aws.bedrock.model.primitives.ImportedModelArn(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.bedrock.model.primitives.RoleArn(value))
    override val modelDataSource
        : Optional[zio.aws.bedrock.model.ModelDataSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modelDataSource())
        .map(value => zio.aws.bedrock.model.ModelDataSource.wrap(value))
    override val status: Optional[zio.aws.bedrock.model.ModelImportJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.bedrock.model.ModelImportJobStatus.wrap(value))
    override val failureMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => zio.aws.bedrock.model.primitives.ErrorMessage(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
    override val importedModelKmsKeyArn: Optional[KmsKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedModelKmsKeyArn())
        .map(value => zio.aws.bedrock.model.primitives.KmsKeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelImportJobResponse
  ): zio.aws.bedrock.model.GetModelImportJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
