package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ModelInvocationJobIdentifier
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetModelInvocationJobRequest(
    jobIdentifier: ModelInvocationJobIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest = {
    import GetModelInvocationJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest
      .builder()
      .jobIdentifier(
        ModelInvocationJobIdentifier.unwrap(jobIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetModelInvocationJobRequest.ReadOnly =
    zio.aws.bedrock.model.GetModelInvocationJobRequest.wrap(buildAwsValue())
}
object GetModelInvocationJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelInvocationJobRequest =
      zio.aws.bedrock.model.GetModelInvocationJobRequest(jobIdentifier)
    def jobIdentifier: ModelInvocationJobIdentifier
    def getJobIdentifier: ZIO[Any, Nothing, ModelInvocationJobIdentifier] =
      ZIO.succeed(jobIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest
  ) extends zio.aws.bedrock.model.GetModelInvocationJobRequest.ReadOnly {
    override val jobIdentifier: ModelInvocationJobIdentifier =
      zio.aws.bedrock.model.primitives
        .ModelInvocationJobIdentifier(impl.jobIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobRequest
  ): zio.aws.bedrock.model.GetModelInvocationJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
