package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ModelInvocationIdempotencyToken,
  ModelInvocationJobName,
  RoleArn,
  Message,
  Timestamp,
  ModelInvocationJobTimeoutDurationInHours,
  ModelInvocationJobArn,
  ModelId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetModelInvocationJobResponse(
    jobArn: ModelInvocationJobArn,
    jobName: Optional[ModelInvocationJobName] = Optional.Absent,
    modelId: ModelId,
    clientRequestToken: Optional[ModelInvocationIdempotencyToken] =
      Optional.Absent,
    roleArn: RoleArn,
    status: Optional[zio.aws.bedrock.model.ModelInvocationJobStatus] =
      Optional.Absent,
    message: Optional[Message] = Optional.Absent,
    submitTime: Timestamp,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    endTime: Optional[Timestamp] = Optional.Absent,
    inputDataConfig: zio.aws.bedrock.model.ModelInvocationJobInputDataConfig,
    outputDataConfig: zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig,
    vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig] = Optional.Absent,
    timeoutDurationInHours: Optional[ModelInvocationJobTimeoutDurationInHours] =
      Optional.Absent,
    jobExpirationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse = {
    import GetModelInvocationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse
      .builder()
      .jobArn(ModelInvocationJobArn.unwrap(jobArn): java.lang.String)
      .optionallyWith(
        jobName.map(value =>
          ModelInvocationJobName.unwrap(value): java.lang.String
        )
      )(_.jobName)
      .modelId(ModelId.unwrap(modelId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ModelInvocationIdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .submitTime(Timestamp.unwrap(submitTime): Instant)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .inputDataConfig(inputDataConfig.buildAwsValue())
      .outputDataConfig(outputDataConfig.buildAwsValue())
      .optionallyWith(vpcConfig.map(value => value.buildAwsValue()))(
        _.vpcConfig
      )
      .optionallyWith(
        timeoutDurationInHours.map(value =>
          ModelInvocationJobTimeoutDurationInHours.unwrap(value): Integer
        )
      )(_.timeoutDurationInHours)
      .optionallyWith(
        jobExpirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.jobExpirationTime)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly =
    zio.aws.bedrock.model.GetModelInvocationJobResponse.wrap(buildAwsValue())
}
object GetModelInvocationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetModelInvocationJobResponse =
      zio.aws.bedrock.model.GetModelInvocationJobResponse(
        jobArn,
        jobName.map(value => value),
        modelId,
        clientRequestToken.map(value => value),
        roleArn,
        status.map(value => value),
        message.map(value => value),
        submitTime,
        lastModifiedTime.map(value => value),
        endTime.map(value => value),
        inputDataConfig.asEditable,
        outputDataConfig.asEditable,
        vpcConfig.map(value => value.asEditable),
        timeoutDurationInHours.map(value => value),
        jobExpirationTime.map(value => value)
      )
    def jobArn: ModelInvocationJobArn
    def jobName: Optional[ModelInvocationJobName]
    def modelId: ModelId
    def clientRequestToken: Optional[ModelInvocationIdempotencyToken]
    def roleArn: RoleArn
    def status: Optional[zio.aws.bedrock.model.ModelInvocationJobStatus]
    def message: Optional[Message]
    def submitTime: Timestamp
    def lastModifiedTime: Optional[Timestamp]
    def endTime: Optional[Timestamp]
    def inputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly
    def outputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly
    def vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly]
    def timeoutDurationInHours
        : Optional[ModelInvocationJobTimeoutDurationInHours]
    def jobExpirationTime: Optional[Timestamp]
    def getJobArn: ZIO[Any, Nothing, ModelInvocationJobArn] =
      ZIO.succeed(jobArn)
    def getJobName: ZIO[Any, AwsError, ModelInvocationJobName] =
      AwsError.unwrapOptionField("jobName", jobName)
    def getModelId: ZIO[Any, Nothing, ModelId] = ZIO.succeed(modelId)
    def getClientRequestToken
        : ZIO[Any, AwsError, ModelInvocationIdempotencyToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.bedrock.model.ModelInvocationJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
    def getSubmitTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(submitTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getInputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly
    ] = ZIO.succeed(inputDataConfig)
    def getOutputDataConfig: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly
    ] = ZIO.succeed(outputDataConfig)
    def getVpcConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      AwsError.unwrapOptionField("vpcConfig", vpcConfig)
    def getTimeoutDurationInHours
        : ZIO[Any, AwsError, ModelInvocationJobTimeoutDurationInHours] =
      AwsError.unwrapOptionField(
        "timeoutDurationInHours",
        timeoutDurationInHours
      )
    def getJobExpirationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("jobExpirationTime", jobExpirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse
  ) extends zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly {
    override val jobArn: ModelInvocationJobArn =
      zio.aws.bedrock.model.primitives.ModelInvocationJobArn(impl.jobArn())
    override val jobName: Optional[ModelInvocationJobName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobName())
        .map(value =>
          zio.aws.bedrock.model.primitives.ModelInvocationJobName(value)
        )
    override val modelId: ModelId =
      zio.aws.bedrock.model.primitives.ModelId(impl.modelId())
    override val clientRequestToken: Optional[ModelInvocationIdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .ModelInvocationIdempotencyToken(value)
        )
    override val roleArn: RoleArn =
      zio.aws.bedrock.model.primitives.RoleArn(impl.roleArn())
    override val status
        : Optional[zio.aws.bedrock.model.ModelInvocationJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.bedrock.model.ModelInvocationJobStatus.wrap(value)
        )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.bedrock.model.primitives.Message(value))
    override val submitTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.submitTime())
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val endTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
    override val inputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobInputDataConfig.ReadOnly =
      zio.aws.bedrock.model.ModelInvocationJobInputDataConfig
        .wrap(impl.inputDataConfig())
    override val outputDataConfig
        : zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig.ReadOnly =
      zio.aws.bedrock.model.ModelInvocationJobOutputDataConfig
        .wrap(impl.outputDataConfig())
    override val vpcConfig: Optional[zio.aws.bedrock.model.VpcConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfig())
        .map(value => zio.aws.bedrock.model.VpcConfig.wrap(value))
    override val timeoutDurationInHours
        : Optional[ModelInvocationJobTimeoutDurationInHours] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutDurationInHours())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .ModelInvocationJobTimeoutDurationInHours(value)
        )
    override val jobExpirationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.jobExpirationTime())
      .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationJobResponse
  ): zio.aws.bedrock.model.GetModelInvocationJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
