package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetModelInvocationLoggingConfigurationResponse(
    loggingConfig: Optional[zio.aws.bedrock.model.LoggingConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse = {
    import GetModelInvocationLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse
      .builder()
      .optionallyWith(loggingConfig.map(value => value.buildAwsValue()))(
        _.loggingConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly =
    zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object GetModelInvocationLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse =
      zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse(
        loggingConfig.map(value => value.asEditable)
      )
    def loggingConfig: Optional[zio.aws.bedrock.model.LoggingConfig.ReadOnly]
    def getLoggingConfig
        : ZIO[Any, AwsError, zio.aws.bedrock.model.LoggingConfig.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfig", loggingConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse
  ) extends zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly {
    override val loggingConfig
        : Optional[zio.aws.bedrock.model.LoggingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfig())
        .map(value => zio.aws.bedrock.model.LoggingConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetModelInvocationLoggingConfigurationResponse
  ): zio.aws.bedrock.model.GetModelInvocationLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
