package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.ProvisionedModelId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetProvisionedModelThroughputRequest(
    provisionedModelId: ProvisionedModelId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest = {
    import GetProvisionedModelThroughputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest
      .builder()
      .provisionedModelId(
        ProvisionedModelId.unwrap(provisionedModelId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GetProvisionedModelThroughputRequest.ReadOnly =
    zio.aws.bedrock.model.GetProvisionedModelThroughputRequest
      .wrap(buildAwsValue())
}
object GetProvisionedModelThroughputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GetProvisionedModelThroughputRequest =
      zio.aws.bedrock.model
        .GetProvisionedModelThroughputRequest(provisionedModelId)
    def provisionedModelId: ProvisionedModelId
    def getProvisionedModelId: ZIO[Any, Nothing, ProvisionedModelId] =
      ZIO.succeed(provisionedModelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest
  ) extends zio.aws.bedrock.model.GetProvisionedModelThroughputRequest.ReadOnly {
    override val provisionedModelId: ProvisionedModelId =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelId(impl.provisionedModelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputRequest
  ): zio.aws.bedrock.model.GetProvisionedModelThroughputRequest.ReadOnly =
    new Wrapper(impl)
}
