package zio.aws.bedrock.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.bedrock.model.primitives.{
  ProvisionedModelArn,
  ErrorMessage,
  ModelArn,
  PositiveInteger,
  Timestamp,
  ProvisionedModelName,
  FoundationModelArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetProvisionedModelThroughputResponse(
    modelUnits: PositiveInteger,
    desiredModelUnits: PositiveInteger,
    provisionedModelName: ProvisionedModelName,
    provisionedModelArn: ProvisionedModelArn,
    modelArn: ModelArn,
    desiredModelArn: ModelArn,
    foundationModelArn: FoundationModelArn,
    status: zio.aws.bedrock.model.ProvisionedModelStatus,
    creationTime: Timestamp,
    lastModifiedTime: Timestamp,
    failureMessage: Optional[ErrorMessage] = Optional.Absent,
    commitmentDuration: Optional[zio.aws.bedrock.model.CommitmentDuration] =
      Optional.Absent,
    commitmentExpirationTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse = {
    import GetProvisionedModelThroughputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse
      .builder()
      .modelUnits(PositiveInteger.unwrap(modelUnits): Integer)
      .desiredModelUnits(PositiveInteger.unwrap(desiredModelUnits): Integer)
      .provisionedModelName(
        ProvisionedModelName.unwrap(provisionedModelName): java.lang.String
      )
      .provisionedModelArn(
        ProvisionedModelArn.unwrap(provisionedModelArn): java.lang.String
      )
      .modelArn(ModelArn.unwrap(modelArn): java.lang.String)
      .desiredModelArn(ModelArn.unwrap(desiredModelArn): java.lang.String)
      .foundationModelArn(
        FoundationModelArn.unwrap(foundationModelArn): java.lang.String
      )
      .status(status.unwrap)
      .creationTime(Timestamp.unwrap(creationTime): Instant)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .optionallyWith(
        failureMessage.map(value =>
          ErrorMessage.unwrap(value): java.lang.String
        )
      )(_.failureMessage)
      .optionallyWith(commitmentDuration.map(value => value.unwrap))(
        _.commitmentDuration
      )
      .optionallyWith(
        commitmentExpirationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.commitmentExpirationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly =
    zio.aws.bedrock.model.GetProvisionedModelThroughputResponse
      .wrap(buildAwsValue())
}
object GetProvisionedModelThroughputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.GetProvisionedModelThroughputResponse =
      zio.aws.bedrock.model.GetProvisionedModelThroughputResponse(
        modelUnits,
        desiredModelUnits,
        provisionedModelName,
        provisionedModelArn,
        modelArn,
        desiredModelArn,
        foundationModelArn,
        status,
        creationTime,
        lastModifiedTime,
        failureMessage.map(value => value),
        commitmentDuration.map(value => value),
        commitmentExpirationTime.map(value => value)
      )
    def modelUnits: PositiveInteger
    def desiredModelUnits: PositiveInteger
    def provisionedModelName: ProvisionedModelName
    def provisionedModelArn: ProvisionedModelArn
    def modelArn: ModelArn
    def desiredModelArn: ModelArn
    def foundationModelArn: FoundationModelArn
    def status: zio.aws.bedrock.model.ProvisionedModelStatus
    def creationTime: Timestamp
    def lastModifiedTime: Timestamp
    def failureMessage: Optional[ErrorMessage]
    def commitmentDuration: Optional[zio.aws.bedrock.model.CommitmentDuration]
    def commitmentExpirationTime: Optional[Timestamp]
    def getModelUnits: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(modelUnits)
    def getDesiredModelUnits: ZIO[Any, Nothing, PositiveInteger] =
      ZIO.succeed(desiredModelUnits)
    def getProvisionedModelName: ZIO[Any, Nothing, ProvisionedModelName] =
      ZIO.succeed(provisionedModelName)
    def getProvisionedModelArn: ZIO[Any, Nothing, ProvisionedModelArn] =
      ZIO.succeed(provisionedModelArn)
    def getModelArn: ZIO[Any, Nothing, ModelArn] = ZIO.succeed(modelArn)
    def getDesiredModelArn: ZIO[Any, Nothing, ModelArn] =
      ZIO.succeed(desiredModelArn)
    def getFoundationModelArn: ZIO[Any, Nothing, FoundationModelArn] =
      ZIO.succeed(foundationModelArn)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.bedrock.model.ProvisionedModelStatus] =
      ZIO.succeed(status)
    def getCreationTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTime)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
    def getFailureMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getCommitmentDuration
        : ZIO[Any, AwsError, zio.aws.bedrock.model.CommitmentDuration] =
      AwsError.unwrapOptionField("commitmentDuration", commitmentDuration)
    def getCommitmentExpirationTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("commitmentExpirationTime", commitmentExpirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse
  ) extends zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly {
    override val modelUnits: PositiveInteger =
      zio.aws.bedrock.model.primitives.PositiveInteger(impl.modelUnits())
    override val desiredModelUnits: PositiveInteger =
      zio.aws.bedrock.model.primitives.PositiveInteger(impl.desiredModelUnits())
    override val provisionedModelName: ProvisionedModelName =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelName(impl.provisionedModelName())
    override val provisionedModelArn: ProvisionedModelArn =
      zio.aws.bedrock.model.primitives
        .ProvisionedModelArn(impl.provisionedModelArn())
    override val modelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.modelArn())
    override val desiredModelArn: ModelArn =
      zio.aws.bedrock.model.primitives.ModelArn(impl.desiredModelArn())
    override val foundationModelArn: FoundationModelArn =
      zio.aws.bedrock.model.primitives
        .FoundationModelArn(impl.foundationModelArn())
    override val status: zio.aws.bedrock.model.ProvisionedModelStatus =
      zio.aws.bedrock.model.ProvisionedModelStatus.wrap(impl.status())
    override val creationTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.creationTime())
    override val lastModifiedTime: Timestamp =
      zio.aws.bedrock.model.primitives.Timestamp(impl.lastModifiedTime())
    override val failureMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => zio.aws.bedrock.model.primitives.ErrorMessage(value))
    override val commitmentDuration
        : Optional[zio.aws.bedrock.model.CommitmentDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commitmentDuration())
        .map(value => zio.aws.bedrock.model.CommitmentDuration.wrap(value))
    override val commitmentExpirationTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commitmentExpirationTime())
        .map(value => zio.aws.bedrock.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GetProvisionedModelThroughputResponse
  ): zio.aws.bedrock.model.GetProvisionedModelThroughputResponse.ReadOnly =
    new Wrapper(impl)
}
