package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContentFilter(
    `type`: zio.aws.bedrock.model.GuardrailContentFilterType,
    inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength,
    outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter = {
    import GuardrailContentFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter
      .builder()
      .`type`(`type`.unwrap)
      .inputStrength(inputStrength.unwrap)
      .outputStrength(outputStrength.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly =
    zio.aws.bedrock.model.GuardrailContentFilter.wrap(buildAwsValue())
}
object GuardrailContentFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContentFilter =
      zio.aws.bedrock.model
        .GuardrailContentFilter(`type`, inputStrength, outputStrength)
    def `type`: zio.aws.bedrock.model.GuardrailContentFilterType
    def inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
    def outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
    def getType
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailContentFilterType] =
      ZIO.succeed(`type`)
    def getInputStrength
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailFilterStrength] =
      ZIO.succeed(inputStrength)
    def getOutputStrength
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailFilterStrength] =
      ZIO.succeed(outputStrength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter
  ) extends zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly {
    override val `type`: zio.aws.bedrock.model.GuardrailContentFilterType =
      zio.aws.bedrock.model.GuardrailContentFilterType.wrap(impl.`type`())
    override val inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength =
      zio.aws.bedrock.model.GuardrailFilterStrength.wrap(impl.inputStrength())
    override val outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength =
      zio.aws.bedrock.model.GuardrailFilterStrength.wrap(impl.outputStrength())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentFilter
  ): zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly = new Wrapper(impl)
}
