package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContentFilterConfig(
    `type`: zio.aws.bedrock.model.GuardrailContentFilterType,
    inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength,
    outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig = {
    import GuardrailContentFilterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig
      .builder()
      .`type`(`type`.unwrap)
      .inputStrength(inputStrength.unwrap)
      .outputStrength(outputStrength.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailContentFilterConfig.wrap(buildAwsValue())
}
object GuardrailContentFilterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContentFilterConfig =
      zio.aws.bedrock.model
        .GuardrailContentFilterConfig(`type`, inputStrength, outputStrength)
    def `type`: zio.aws.bedrock.model.GuardrailContentFilterType
    def inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
    def outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength
    def getType
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailContentFilterType] =
      ZIO.succeed(`type`)
    def getInputStrength
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailFilterStrength] =
      ZIO.succeed(inputStrength)
    def getOutputStrength
        : ZIO[Any, Nothing, zio.aws.bedrock.model.GuardrailFilterStrength] =
      ZIO.succeed(outputStrength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig
  ) extends zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly {
    override val `type`: zio.aws.bedrock.model.GuardrailContentFilterType =
      zio.aws.bedrock.model.GuardrailContentFilterType.wrap(impl.`type`())
    override val inputStrength: zio.aws.bedrock.model.GuardrailFilterStrength =
      zio.aws.bedrock.model.GuardrailFilterStrength.wrap(impl.inputStrength())
    override val outputStrength: zio.aws.bedrock.model.GuardrailFilterStrength =
      zio.aws.bedrock.model.GuardrailFilterStrength.wrap(impl.outputStrength())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterConfig
  ): zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly = new Wrapper(
    impl
  )
}
