package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailContentFilterType {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType
}
object GuardrailContentFilterType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType
  ): zio.aws.bedrock.model.GuardrailContentFilterType = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.SEXUAL =>
      val r = SEXUAL
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.VIOLENCE =>
      val r = VIOLENCE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.HATE =>
      val r = HATE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.INSULTS =>
      val r = INSULTS
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.MISCONDUCT =>
      val r = MISCONDUCT
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.PROMPT_ATTACK =>
      val r = PROMPT_ATTACK
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object SEXUAL extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.SEXUAL
  }
  case object VIOLENCE
      extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.VIOLENCE
  }
  case object HATE extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.HATE
  }
  case object INSULTS extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.INSULTS
  }
  case object MISCONDUCT
      extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.MISCONDUCT
  }
  case object PROMPT_ATTACK
      extends zio.aws.bedrock.model.GuardrailContentFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType.PROMPT_ATTACK
  }
}
