package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailContentPolicy(
    filters: Optional[Iterable[zio.aws.bedrock.model.GuardrailContentFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy = {
    import GuardrailContentPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly =
    zio.aws.bedrock.model.GuardrailContentPolicy.wrap(buildAwsValue())
}
object GuardrailContentPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContentPolicy =
      zio.aws.bedrock.model.GuardrailContentPolicy(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def filters
        : Optional[List[zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly]]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy
  ) extends zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly {
    override val filters: Optional[
      List[zio.aws.bedrock.model.GuardrailContentFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.bedrock.model.GuardrailContentFilter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy
  ): zio.aws.bedrock.model.GuardrailContentPolicy.ReadOnly = new Wrapper(impl)
}
