package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContentPolicyConfig(
    filtersConfig: Iterable[zio.aws.bedrock.model.GuardrailContentFilterConfig]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig = {
    import GuardrailContentPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig
      .builder()
      .filtersConfig(filtersConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailContentPolicyConfig.wrap(buildAwsValue())
}
object GuardrailContentPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContentPolicyConfig =
      zio.aws.bedrock.model.GuardrailContentPolicyConfig(filtersConfig.map {
        item =>
          item.asEditable
      })
    def filtersConfig
        : List[zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly]
    def getFiltersConfig: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly
    ]] = ZIO.succeed(filtersConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig
  ) extends zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly {
    override val filtersConfig
        : List[zio.aws.bedrock.model.GuardrailContentFilterConfig.ReadOnly] =
      impl
        .filtersConfig()
        .asScala
        .map { item =>
          zio.aws.bedrock.model.GuardrailContentFilterConfig.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicyConfig
  ): zio.aws.bedrock.model.GuardrailContentPolicyConfig.ReadOnly = new Wrapper(
    impl
  )
}
