package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.GuardrailContextualGroundingFilterThresholdDouble
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContextualGroundingFilter(
    `type`: zio.aws.bedrock.model.GuardrailContextualGroundingFilterType,
    threshold: GuardrailContextualGroundingFilterThresholdDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilter = {
    import GuardrailContextualGroundingFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilter
      .builder()
      .`type`(`type`.unwrap)
      .threshold(
        GuardrailContextualGroundingFilterThresholdDouble.unwrap(
          threshold
        ): java.lang.Double
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly =
    zio.aws.bedrock.model.GuardrailContextualGroundingFilter
      .wrap(buildAwsValue())
}
object GuardrailContextualGroundingFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContextualGroundingFilter =
      zio.aws.bedrock.model
        .GuardrailContextualGroundingFilter(`type`, threshold)
    def `type`: zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
    def threshold: GuardrailContextualGroundingFilterThresholdDouble
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
    ] = ZIO.succeed(`type`)
    def getThreshold
        : ZIO[Any, Nothing, GuardrailContextualGroundingFilterThresholdDouble] =
      ZIO.succeed(threshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilter
  ) extends zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly {
    override val `type`
        : zio.aws.bedrock.model.GuardrailContextualGroundingFilterType =
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
        .wrap(impl.`type`())
    override val threshold: GuardrailContextualGroundingFilterThresholdDouble =
      zio.aws.bedrock.model.primitives
        .GuardrailContextualGroundingFilterThresholdDouble(impl.threshold())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilter
  ): zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly =
    new Wrapper(impl)
}
