package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.GuardrailContextualGroundingFilterConfigThresholdDouble
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContextualGroundingFilterConfig(
    `type`: zio.aws.bedrock.model.GuardrailContextualGroundingFilterType,
    threshold: GuardrailContextualGroundingFilterConfigThresholdDouble
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterConfig = {
    import GuardrailContextualGroundingFilterConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterConfig
      .builder()
      .`type`(`type`.unwrap)
      .threshold(
        GuardrailContextualGroundingFilterConfigThresholdDouble.unwrap(
          threshold
        ): java.lang.Double
      )
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig
      .wrap(buildAwsValue())
}
object GuardrailContextualGroundingFilterConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig =
      zio.aws.bedrock.model
        .GuardrailContextualGroundingFilterConfig(`type`, threshold)
    def `type`: zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
    def threshold: GuardrailContextualGroundingFilterConfigThresholdDouble
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
    ] = ZIO.succeed(`type`)
    def getThreshold: ZIO[
      Any,
      Nothing,
      GuardrailContextualGroundingFilterConfigThresholdDouble
    ] = ZIO.succeed(threshold)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterConfig
  ) extends zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly {
    override val `type`
        : zio.aws.bedrock.model.GuardrailContextualGroundingFilterType =
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterType
        .wrap(impl.`type`())
    override val threshold
        : GuardrailContextualGroundingFilterConfigThresholdDouble =
      zio.aws.bedrock.model.primitives
        .GuardrailContextualGroundingFilterConfigThresholdDouble(
          impl.threshold()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterConfig
  ): zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly =
    new Wrapper(impl)
}
