package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailContextualGroundingFilterType {
  def unwrap: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType
}
object GuardrailContextualGroundingFilterType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType
  ): zio.aws.bedrock.model.GuardrailContextualGroundingFilterType =
    value match {
      case software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.GROUNDING =>
        val r = GROUNDING
        r
      case software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.RELEVANCE =>
        val r = RELEVANCE
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailContextualGroundingFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object GROUNDING
      extends zio.aws.bedrock.model.GuardrailContextualGroundingFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.GROUNDING
  }
  case object RELEVANCE
      extends zio.aws.bedrock.model.GuardrailContextualGroundingFilterType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType =
      software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType.RELEVANCE
  }
}
