package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContextualGroundingPolicy(
    filters: Iterable[zio.aws.bedrock.model.GuardrailContextualGroundingFilter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy = {
    import GuardrailContextualGroundingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy
      .builder()
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly =
    zio.aws.bedrock.model.GuardrailContextualGroundingPolicy
      .wrap(buildAwsValue())
}
object GuardrailContextualGroundingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailContextualGroundingPolicy =
      zio.aws.bedrock.model.GuardrailContextualGroundingPolicy(filters.map {
        item =>
          item.asEditable
      })
    def filters: List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly
    ]
    def getFilters: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly
    ]] = ZIO.succeed(filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy
  ) extends zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly {
    override val filters: List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilter.ReadOnly
    ] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.GuardrailContextualGroundingFilter.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy
  ): zio.aws.bedrock.model.GuardrailContextualGroundingPolicy.ReadOnly =
    new Wrapper(impl)
}
