package zio.aws.bedrock.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GuardrailContextualGroundingPolicyConfig(
    filtersConfig: Iterable[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig = {
    import GuardrailContextualGroundingPolicyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig
      .builder()
      .filtersConfig(filtersConfig.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig
      .wrap(buildAwsValue())
}
object GuardrailContextualGroundingPolicyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig =
      zio.aws.bedrock.model
        .GuardrailContextualGroundingPolicyConfig(filtersConfig.map { item =>
          item.asEditable
        })
    def filtersConfig: List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly
    ]
    def getFiltersConfig: ZIO[Any, Nothing, List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly
    ]] = ZIO.succeed(filtersConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig
  ) extends zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly {
    override val filtersConfig: List[
      zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig.ReadOnly
    ] = impl
      .filtersConfig()
      .asScala
      .map { item =>
        zio.aws.bedrock.model.GuardrailContextualGroundingFilterConfig
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicyConfig
  ): zio.aws.bedrock.model.GuardrailContextualGroundingPolicyConfig.ReadOnly =
    new Wrapper(impl)
}
