package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailFilterStrength {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength
}
object GuardrailFilterStrength {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength
  ): zio.aws.bedrock.model.GuardrailFilterStrength = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailFilterStrength {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength =
      software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.bedrock.model.GuardrailFilterStrength {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength =
      software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.NONE
  }
  case object LOW extends zio.aws.bedrock.model.GuardrailFilterStrength {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength =
      software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.LOW
  }
  case object MEDIUM extends zio.aws.bedrock.model.GuardrailFilterStrength {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength =
      software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.MEDIUM
  }
  case object HIGH extends zio.aws.bedrock.model.GuardrailFilterStrength {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength =
      software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength.HIGH
  }
}
