package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailManagedWordsType {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType
}
object GuardrailManagedWordsType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType
  ): zio.aws.bedrock.model.GuardrailManagedWordsType = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType.PROFANITY =>
      val r = PROFANITY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailManagedWordsType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType =
      software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROFANITY
      extends zio.aws.bedrock.model.GuardrailManagedWordsType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType =
      software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsType.PROFANITY
  }
}
