package zio.aws.bedrock.model
import scala.jdk.CollectionConverters._
sealed trait GuardrailPiiEntityType {
  def unwrap
      : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType
}
object GuardrailPiiEntityType {
  def wrap(
      value: software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType
  ): zio.aws.bedrock.model.GuardrailPiiEntityType = value match {
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.ADDRESS =>
      val r = ADDRESS
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AGE =>
      val r = AGE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AWS_ACCESS_KEY =>
      val r = AWS_ACCESS_KEY
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AWS_SECRET_KEY =>
      val r = AWS_SECRET_KEY
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CA_HEALTH_NUMBER =>
      val r = CA_HEALTH_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CA_SOCIAL_INSURANCE_NUMBER =>
      val r = CA_SOCIAL_INSURANCE_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_CVV =>
      val r = CREDIT_DEBIT_CARD_CVV
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_EXPIRY =>
      val r = CREDIT_DEBIT_CARD_EXPIRY
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_NUMBER =>
      val r = CREDIT_DEBIT_CARD_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.DRIVER_ID =>
      val r = DRIVER_ID
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.INTERNATIONAL_BANK_ACCOUNT_NUMBER =>
      val r = INTERNATIONAL_BANK_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.IP_ADDRESS =>
      val r = IP_ADDRESS
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.LICENSE_PLATE =>
      val r = LICENSE_PLATE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.MAC_ADDRESS =>
      val r = MAC_ADDRESS
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PASSWORD =>
      val r = PASSWORD
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PHONE =>
      val r = PHONE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PIN =>
      val r = PIN
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.SWIFT_CODE =>
      val r = SWIFT_CODE
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_NATIONAL_HEALTH_SERVICE_NUMBER =>
      val r = UK_NATIONAL_HEALTH_SERVICE_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_NATIONAL_INSURANCE_NUMBER =>
      val r = UK_NATIONAL_INSURANCE_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER =>
      val r = UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.URL =>
      val r = URL
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.USERNAME =>
      val r = USERNAME
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_BANK_ACCOUNT_NUMBER =>
      val r = US_BANK_ACCOUNT_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_BANK_ROUTING_NUMBER =>
      val r = US_BANK_ROUTING_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER =>
      val r = US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_PASSPORT_NUMBER =>
      val r = US_PASSPORT_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_SOCIAL_SECURITY_NUMBER =>
      val r = US_SOCIAL_SECURITY_NUMBER
      r
    case software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.VEHICLE_IDENTIFICATION_NUMBER =>
      val r = VEHICLE_IDENTIFICATION_NUMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object ADDRESS extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.ADDRESS
  }
  case object AGE extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AGE
  }
  case object AWS_ACCESS_KEY
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AWS_ACCESS_KEY
  }
  case object AWS_SECRET_KEY
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.AWS_SECRET_KEY
  }
  case object CA_HEALTH_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CA_HEALTH_NUMBER
  }
  case object CA_SOCIAL_INSURANCE_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CA_SOCIAL_INSURANCE_NUMBER
  }
  case object CREDIT_DEBIT_CARD_CVV
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_CVV
  }
  case object CREDIT_DEBIT_CARD_EXPIRY
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_EXPIRY
  }
  case object CREDIT_DEBIT_CARD_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.CREDIT_DEBIT_CARD_NUMBER
  }
  case object DRIVER_ID extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.DRIVER_ID
  }
  case object EMAIL extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.EMAIL
  }
  case object INTERNATIONAL_BANK_ACCOUNT_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.INTERNATIONAL_BANK_ACCOUNT_NUMBER
  }
  case object IP_ADDRESS extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.IP_ADDRESS
  }
  case object LICENSE_PLATE
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.LICENSE_PLATE
  }
  case object MAC_ADDRESS extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.MAC_ADDRESS
  }
  case object NAME extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.NAME
  }
  case object PASSWORD extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PASSWORD
  }
  case object PHONE extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PHONE
  }
  case object PIN extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.PIN
  }
  case object SWIFT_CODE extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.SWIFT_CODE
  }
  case object UK_NATIONAL_HEALTH_SERVICE_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_NATIONAL_HEALTH_SERVICE_NUMBER
  }
  case object UK_NATIONAL_INSURANCE_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_NATIONAL_INSURANCE_NUMBER
  }
  case object UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
  }
  case object URL extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.URL
  }
  case object USERNAME extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.USERNAME
  }
  case object US_BANK_ACCOUNT_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_BANK_ACCOUNT_NUMBER
  }
  case object US_BANK_ROUTING_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_BANK_ROUTING_NUMBER
  }
  case object US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
  }
  case object US_PASSPORT_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_PASSPORT_NUMBER
  }
  case object US_SOCIAL_SECURITY_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.US_SOCIAL_SECURITY_NUMBER
  }
  case object VEHICLE_IDENTIFICATION_NUMBER
      extends zio.aws.bedrock.model.GuardrailPiiEntityType {
    override def unwrap
        : software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType =
      software.amazon.awssdk.services.bedrock.model.GuardrailPiiEntityType.VEHICLE_IDENTIFICATION_NUMBER
  }
}
