package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailRegexPatternString,
  GuardrailRegexDescriptionString,
  GuardrailRegexNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailRegex(
    name: GuardrailRegexNameString,
    description: Optional[GuardrailRegexDescriptionString] = Optional.Absent,
    pattern: GuardrailRegexPatternString,
    action: zio.aws.bedrock.model.GuardrailSensitiveInformationAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailRegex = {
    import GuardrailRegex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailRegex
      .builder()
      .name(GuardrailRegexNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GuardrailRegexDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .pattern(GuardrailRegexPatternString.unwrap(pattern): java.lang.String)
      .action(action.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailRegex.ReadOnly =
    zio.aws.bedrock.model.GuardrailRegex.wrap(buildAwsValue())
}
object GuardrailRegex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailRegex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailRegex = zio.aws.bedrock.model
      .GuardrailRegex(name, description.map(value => value), pattern, action)
    def name: GuardrailRegexNameString
    def description: Optional[GuardrailRegexDescriptionString]
    def pattern: GuardrailRegexPatternString
    def action: zio.aws.bedrock.model.GuardrailSensitiveInformationAction
    def getName: ZIO[Any, Nothing, GuardrailRegexNameString] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, GuardrailRegexDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getPattern: ZIO[Any, Nothing, GuardrailRegexPatternString] =
      ZIO.succeed(pattern)
    def getAction: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.GuardrailSensitiveInformationAction
    ] = ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailRegex
  ) extends zio.aws.bedrock.model.GuardrailRegex.ReadOnly {
    override val name: GuardrailRegexNameString =
      zio.aws.bedrock.model.primitives.GuardrailRegexNameString(impl.name())
    override val description: Optional[GuardrailRegexDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .GuardrailRegexDescriptionString(value)
        )
    override val pattern: GuardrailRegexPatternString =
      zio.aws.bedrock.model.primitives
        .GuardrailRegexPatternString(impl.pattern())
    override val action
        : zio.aws.bedrock.model.GuardrailSensitiveInformationAction =
      zio.aws.bedrock.model.GuardrailSensitiveInformationAction
        .wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailRegex
  ): zio.aws.bedrock.model.GuardrailRegex.ReadOnly = new Wrapper(impl)
}
