package zio.aws.bedrock.model
import zio.aws.bedrock.model.primitives.{
  GuardrailRegexConfigPatternString,
  GuardrailRegexConfigDescriptionString,
  GuardrailRegexConfigNameString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GuardrailRegexConfig(
    name: GuardrailRegexConfigNameString,
    description: Optional[GuardrailRegexConfigDescriptionString] =
      Optional.Absent,
    pattern: GuardrailRegexConfigPatternString,
    action: zio.aws.bedrock.model.GuardrailSensitiveInformationAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig = {
    import GuardrailRegexConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig
      .builder()
      .name(GuardrailRegexConfigNameString.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          GuardrailRegexConfigDescriptionString.unwrap(value): java.lang.String
        )
      )(_.description)
      .pattern(
        GuardrailRegexConfigPatternString.unwrap(pattern): java.lang.String
      )
      .action(action.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly =
    zio.aws.bedrock.model.GuardrailRegexConfig.wrap(buildAwsValue())
}
object GuardrailRegexConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.bedrock.model.GuardrailRegexConfig =
      zio.aws.bedrock.model.GuardrailRegexConfig(
        name,
        description.map(value => value),
        pattern,
        action
      )
    def name: GuardrailRegexConfigNameString
    def description: Optional[GuardrailRegexConfigDescriptionString]
    def pattern: GuardrailRegexConfigPatternString
    def action: zio.aws.bedrock.model.GuardrailSensitiveInformationAction
    def getName: ZIO[Any, Nothing, GuardrailRegexConfigNameString] =
      ZIO.succeed(name)
    def getDescription
        : ZIO[Any, AwsError, GuardrailRegexConfigDescriptionString] =
      AwsError.unwrapOptionField("description", description)
    def getPattern: ZIO[Any, Nothing, GuardrailRegexConfigPatternString] =
      ZIO.succeed(pattern)
    def getAction: ZIO[
      Any,
      Nothing,
      zio.aws.bedrock.model.GuardrailSensitiveInformationAction
    ] = ZIO.succeed(action)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig
  ) extends zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly {
    override val name: GuardrailRegexConfigNameString =
      zio.aws.bedrock.model.primitives
        .GuardrailRegexConfigNameString(impl.name())
    override val description: Optional[GuardrailRegexConfigDescriptionString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.bedrock.model.primitives
            .GuardrailRegexConfigDescriptionString(value)
        )
    override val pattern: GuardrailRegexConfigPatternString =
      zio.aws.bedrock.model.primitives
        .GuardrailRegexConfigPatternString(impl.pattern())
    override val action
        : zio.aws.bedrock.model.GuardrailSensitiveInformationAction =
      zio.aws.bedrock.model.GuardrailSensitiveInformationAction
        .wrap(impl.action())
  }
  def wrap(
      impl: software.amazon.awssdk.services.bedrock.model.GuardrailRegexConfig
  ): zio.aws.bedrock.model.GuardrailRegexConfig.ReadOnly = new Wrapper(impl)
}
